/// <reference types="node" />
import { IUdpSocket, UdpSocketEvent } from './IUdpSocket';
/**
 * UDP socket implementation.
 *
 * Handles sending and receiving messages via UDP.
 */
export declare class UdpSocket implements IUdpSocket<Buffer> {
    private port;
    private emitter;
    private socket;
    constructor(port: number);
    open(): Promise<void>;
    close(): Promise<void>;
    send(messageBuffer: Buffer): Promise<void>;
    addListener(event: UdpSocketEvent, callback: (message: Buffer) => void): void;
    removeListener(event: UdpSocketEvent, callback: (message: Buffer) => void): void;
    private createSocket;
    private handleMessage;
}
