"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TcpSocket = void 0;
const events_1 = require("events");
const ITcpSocket_1 = require("./ITcpSocket");
const TcpClient_1 = require("./TcpClient");
const TcpServer_1 = require("./TcpServer");
class TcpSocket {
    constructor(config) {
        this.config = config;
        this.emitter = new events_1.EventEmitter();
        this.server = new TcpServer_1.TcpServer(config.port, config.clientConnectionTTLMs);
        this.listenToServerEvents();
    }
    open() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.server.open();
        });
    }
    close() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.server.close();
        });
    }
    send(args) {
        return __awaiter(this, void 0, void 0, function* () {
            const client = new TcpClient_1.TcpClient({
                host: args.host,
                port: args.port,
                connectionTimeoutMs: this.config.clientConnectionTimeoutMs,
            });
            yield client.connect();
            try {
                yield client.send(args.message);
            }
            finally {
                yield client.close();
            }
        });
    }
    addListener(event, callback) {
        this.emitter.addListener(event, callback);
    }
    removeListener(event, callback) {
        this.emitter.removeListener(event, callback);
    }
    listenToServerEvents() {
        this.server.addListener(TcpServer_1.TcpServerEvent.Message, (message) => {
            this.handleMessage(message);
        });
        this.server.addListener(TcpServer_1.TcpServerEvent.Closed, (error) => {
            this.emitter.emit(ITcpSocket_1.TcpSocketEvent.Closed, error);
        });
    }
    handleMessage(message) {
        this.emitter.emit(ITcpSocket_1.TcpSocketEvent.Message, message);
    }
}
exports.TcpSocket = TcpSocket;
//# sourceMappingURL=TcpSocket.js.map