"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrderedTcpSocket = void 0;
const async_lock_1 = __importDefault(require("async-lock"));
/**
 * Wrapper class for ITcpSocket that ensures that messages to the same destination are sent in order
 *
 * The reason for creation of this class is the following real-life scenario:
 * There were 2 devices, connected to the same Wi-Fi network. The network was slow.
 * Once in a while it happened that several messages were sent to the same device in a quick succession
 * and one of the messages was received by the other devices out of order.
 * In other words, device A sent messages 1, 2, and 3 and device B received them in the order 1, 3, 2.
 *
 * This class ensures that messages are sent in order, so that the above scenario doesn't happen.
 */
class OrderedTcpSocket {
    constructor(baseTcpSocket) {
        this.baseTcpSocket = baseTcpSocket;
        this.lock = new async_lock_1.default({
            maxPending: 100, // max 100 pending messages for a single destination
        });
        this.addListener = this.baseTcpSocket.addListener.bind(this.baseTcpSocket);
        this.removeListener = this.baseTcpSocket.removeListener.bind(this.baseTcpSocket);
    }
    close() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.baseTcpSocket.close();
        });
    }
    send(args) {
        return __awaiter(this, void 0, void 0, function* () {
            const dest = this.getSendDestinationAsString(args);
            // this will ensure that messages to the same destination are sent in order
            yield this.lock.acquire(dest, () => __awaiter(this, void 0, void 0, function* () {
                yield this.baseTcpSocket.send(args);
            }));
        });
    }
    getSendDestinationAsString(args) {
        return `${args.host}:${args.port}`;
    }
}
exports.OrderedTcpSocket = OrderedTcpSocket;
//# sourceMappingURL=OrderedTcpSocket.js.map