"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageTcpSocket = void 0;
const events_1 = require("events");
const ITcpSocket_1 = require("./ITcpSocket");
class MessageTcpSocket {
    constructor(socket, serializer) {
        this.socket = socket;
        this.serializer = serializer;
        this.emitter = new events_1.EventEmitter();
        this.handleSocketMessage = this.handleSocketMessage.bind(this);
        this.listenToSocket();
    }
    close() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.socket.close();
            this.socket.removeListener(ITcpSocket_1.TcpSocketEvent.Message, this.handleSocketMessage);
        });
    }
    send(args) {
        return __awaiter(this, void 0, void 0, function* () {
            const serializedMessage = this.serializer.serialize(args.message);
            yield this.socket.send({
                host: args.host,
                port: args.port,
                message: serializedMessage,
            });
        });
    }
    addListener(event, callback) {
        this.emitter.addListener(event, callback);
    }
    removeListener(event, callback) {
        this.emitter.removeListener(event, callback);
    }
    listenToSocket() {
        this.socket.addListener(ITcpSocket_1.TcpSocketEvent.Message, this.handleSocketMessage);
    }
    handleSocketMessage(serializedMessage) {
        const message = this.serializer.deserialize(serializedMessage);
        this.emitter.emit(ITcpSocket_1.TcpSocketEvent.Message, message);
    }
}
exports.MessageTcpSocket = MessageTcpSocket;
//# sourceMappingURL=MessageTcpSocket.js.map