"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeSocketSerializer = void 0;
const serialization_1 = require("./serialization");
class NodeSocketSerializer {
    serialize(message) {
        const encodedMessage = JSON.stringify(message);
        return this.convertToBuffer(encodedMessage);
    }
    deserialize(buffer) {
        const messageString = buffer.toString();
        return (0, serialization_1.parseMessage)(messageString);
    }
    convertToBuffer(data) {
        const nodeVersionMatch = process.version.match(/^v(\d)/);
        const nodeVersion = (nodeVersionMatch && parseInt(nodeVersionMatch[1])) || null;
        // Buffer.from was added in NodeJS 5.10.0 but some platforms we have to support have older NodeJS version than that.
        // Also new Buffer is deprecated since version 6.
        // This is the easiest way to ensure support for all versions.
        if (nodeVersion && nodeVersion >= 6) {
            return Buffer.from(data);
        }
        else {
            return new Buffer(data);
        }
    }
}
exports.NodeSocketSerializer = NodeSocketSerializer;
//# sourceMappingURL=NodeSocketSerializer.js.map