"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientSocketSerializer = void 0;
const serialization_1 = require("./serialization");
const buffer_1 = require("buffer");
class ClientSocketSerializer {
    serialize(message) {
        const encodedMessage = JSON.stringify(message);
        return buffer_1.Buffer.from(encodedMessage);
    }
    deserialize(messageBuffer) {
        const messageString = buffer_1.Buffer.from(messageBuffer).toString('utf-8');
        return (0, serialization_1.parseMessage)(messageString);
    }
}
exports.ClientSocketSerializer = ClientSocketSerializer;
//# sourceMappingURL=ClientSocketSerializer.js.map