import { ITcpSocket } from './Socket/Tcp/ITcpSocket';
import { ClosedListener, IPeerNetwork, MessageListener, PeerNetworkEvent, PeerNetworkPeer, PeersChangedListener } from './IPeerNetwork';
import { IPeerDiscoveryService } from './PeerDiscoveryService/IPeerDiscoveryService';
export declare class PeerNetwork implements IPeerNetwork {
    private peerDiscoveryService;
    private createSocket;
    private emitter;
    private socket;
    private started;
    constructor(peerDiscoveryService: IPeerDiscoveryService, createSocket: () => Promise<ITcpSocket<object>>);
    start(): Promise<void>;
    stop(): Promise<void>;
    isStarted(): boolean;
    getMe(): PeerNetworkPeer;
    getPeers(): PeerNetworkPeer[];
    send(message: object): Promise<void>;
    addListener(event: PeerNetworkEvent.Message, callback: MessageListener): void;
    addListener(event: PeerNetworkEvent.PeersChanged, callback: PeersChangedListener): void;
    addListener(event: PeerNetworkEvent.Closed, callback: ClosedListener): void;
    removeListener(event: PeerNetworkEvent.Message, callback: MessageListener): void;
    removeListener(event: PeerNetworkEvent.PeersChanged, callback: PeersChangedListener): void;
    removeListener(event: PeerNetworkEvent.Closed, callback: ClosedListener): void;
    private listenToPeerChanges;
    private handlePeersChanged;
    private openSocket;
    private closeSocket;
    private handleSocketMessage;
    private handleSocketClosed;
}
