"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLocalAddress = void 0;
const os_1 = require("os");
function getLocalAddress() {
    return __awaiter(this, void 0, void 0, function* () {
        const interfaces = (0, os_1.networkInterfaces)();
        for (const interfaceName in interfaces) {
            const subInterface = interfaces[interfaceName];
            if (subInterface !== undefined) {
                for (const { address, internal, family } of subInterface) {
                    if (!internal && family === 'IPv4') {
                        return address;
                    }
                }
            }
        }
        return null;
    });
}
exports.getLocalAddress = getLocalAddress;
//# sourceMappingURL=PeerDiscoveryService.utils.js.map