export interface PeerNetworkPeer {
    id: string;
    aliveAt: Date;
}
export declare enum PeerNetworkEvent {
    Message = "message",
    PeersChanged = "peers_changed",
    Closed = "closed"
}
export interface PeerNetworkMessage<TMessage extends object = object> {
    fromId: PeerNetworkPeer['id'];
    message: TMessage;
}
export declare function isPeerNetworkMessage(message: unknown): message is PeerNetworkMessage;
export type MessageListener = (message: PeerNetworkMessage) => void;
export type PeersChangedListener = () => void;
export type ClosedListener = (error?: Error) => void;
export type PeerNetworkEventListener = MessageListener | PeersChangedListener | ClosedListener;
/**
 * Abstract representation of a network of peers that can broadcast messages to each other
 */
export interface IPeerNetwork {
    start(): Promise<void>;
    stop(): Promise<void>;
    isStarted(): boolean;
    getMe(): PeerNetworkPeer;
    getPeers(): PeerNetworkPeer[];
    /** broadcast message to the network */
    send(message: object): Promise<void>;
    addListener(event: PeerNetworkEvent.Message, callback: MessageListener): void;
    addListener(event: PeerNetworkEvent.PeersChanged, callback: PeersChangedListener): void;
    addListener(event: PeerNetworkEvent.Closed, callback: ClosedListener): void;
    removeListener(event: PeerNetworkEvent.Message, callback: MessageListener): void;
    removeListener(event: PeerNetworkEvent.PeersChanged, callback: PeersChangedListener): void;
    removeListener(event: PeerNetworkEvent.Closed, callback: ClosedListener): void;
}
