import { IFilePath } from '../NativeDevice/fileSystem';
import IFileSystem from '../NativeDevice/IFileSystem';
import HashAlgorithm from '../NativeDevice/HashAlgorithm';
export default class OfflineCache {
    private fileSystem;
    private asyncLock;
    private storageUnitsCache;
    constructor(fileSystem: IFileSystem);
    retriableDownloadFile(countOfRetrials: number, uid: string, uri: string, headers?: {
        [key: string]: string;
    }, forceInternalStorageUnit?: boolean): Promise<void>;
    fileExists(uid: string): Promise<boolean>;
    fileIsDirectory(uid: string): Promise<boolean>;
    getFile(uid: string): Promise<import("../NativeDevice/fileSystem").IFile | null>;
    getFullFilePath(uid: string): Promise<IFilePath>;
    readFile(uid: string): Promise<string>;
    deleteFile(uid: string, recursive: boolean): Promise<void>;
    deleteFileAndDeleteDirectoryIfEmpty(uid: string, recursive?: boolean): Promise<void>;
    getFileChecksum(uid: string, hashType: HashAlgorithm): Promise<string>;
    extractFile(archiveUid: string, destinationDirectoryUid: string, method: string, forceInternalStorageUnit?: boolean): Promise<void>;
    getArchiveInfo(uid: string): Promise<import("../NativeDevice/IFileSystem").IArchiveInfo>;
    listFilesRecursively(directoryUid?: string): Promise<string[]>;
    listFileUids(directoryUid: string): Promise<string[]>;
    private deleteDirectoryIfEmpty;
    private ensureDirectory;
    private getParentDirectoryPath;
    private isRootFilePath;
    private getMostFreeStorageUnit;
    private getStorageUnits;
    private addDataPrefixToUid;
    private stripDataPrefixFromPath;
    private createFileNotFoundError;
}
