export interface IStorageUnit {
    /**
     * A user visible storage unit identifier.
     *
     * This property is an opaque string. Do not assume that its value has any particular structure.
     */
    type: string;
    /** Returns the size of the storage unit in bytes. */
    capacity: number;
    /** Returns the number of unallocated bytes in the storage unit. This may be more than {@link usableSpace}. */
    freeSpace: number;
    /** Returns the number of bytes available for use in the storage unit. This may be less than {@link freeSpace}. */
    usableSpace: number;
    removable: boolean;
}
export interface IFile {
    localUri: string;
    imageThumbnailUriTemplate?: string;
    videoThumbnailUriTemplate?: string;
    createdAt?: number;
    lastModifiedAt?: number;
    sizeBytes?: number;
    mimeType?: string;
}
export interface IVideoFile extends IFile {
    videoDurationMs?: number;
    videoResolution?: {
        width: number;
        height: number;
    };
    videoFramerate?: number;
    videoBitrate?: number;
    videoCodec?: string;
    audioBitrate?: number;
    audioCodec?: string;
}
export interface IHeaders {
    [key: string]: string;
}
export interface IFilePath {
    storageUnit: IStorageUnit;
    filePath: string;
}
export interface IMetadata {
    originalResponseHeaders: IHeaders;
    originalRequestHeaders: IHeaders | undefined;
    originalSourceUri: string;
    createdAt: number;
}
export interface ISimpleHeaders {
    has(name: string): boolean;
    get(name: string): string | undefined;
    forEach(callback: (value: string, key: string) => void): void;
}
export type ISimpleResponse = {
    ok: boolean;
    body: unknown | null;
    headers: ISimpleHeaders;
    blob(): Promise<Blob>;
    text(): Promise<string>;
};
