"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveCurrentBrightness = void 0;
const moment_timezone_1 = __importDefault(require("moment-timezone"));
function resolveCurrentBrightness(timeFrom1, brightness1, timeFrom2, brightness2, now) {
    const nowMoment = (0, moment_timezone_1.default)(now);
    let timeFrom1Moment = (0, moment_timezone_1.default)(nowMoment.format('YYYY-MM-DD') + ' ' + timeFrom1, 'YYYY-MM-DD HH:mm:ss');
    let timeFrom2Moment = (0, moment_timezone_1.default)(nowMoment.format('YYYY-MM-DD') + ' ' + timeFrom2, 'YYYY-MM-DD HH:mm:ss');
    if (timeFrom2Moment.isBefore(timeFrom1Moment)) {
        [timeFrom1Moment, brightness1, timeFrom2Moment, brightness2] = [timeFrom2Moment, brightness2, timeFrom1Moment, brightness1]; // swap
    }
    if (nowMoment.isSameOrAfter(timeFrom1Moment) && nowMoment.isBefore(timeFrom2Moment)) {
        return brightness1;
    }
    return brightness2;
}
exports.resolveCurrentBrightness = resolveCurrentBrightness;
//# sourceMappingURL=screenHelper.js.map