"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Orientation_1 = __importDefault(require("@signageos/common-types/dist/Device/Resolution/Orientation"));
class ScreenRotationPixelPropsProvider {
    /**
     * @param rotateClockwise On most platforms, counter-clockwise should be the correct option
     * @param resContains Usually a simple window, but with limited access to inner resolutions only
     */
    constructor(rotateClockwise, resContainer) {
        this.rotateClockwise = rotateClockwise;
        this.resContainer = resContainer;
    }
    getProps(orientation) {
        if (this.rotateClockwise) {
            return this.getClockwiseProps(orientation);
        }
        else {
            return this.getCounterClockwiseProps(orientation);
        }
    }
    getClockwiseProps(orientation) {
        switch (orientation) {
            case Orientation_1.default.PORTRAIT:
                return this.getCounterClockwiseProps(Orientation_1.default.PORTRAIT_FLIPPED);
            case Orientation_1.default.PORTRAIT_FLIPPED:
                return this.getCounterClockwiseProps(Orientation_1.default.PORTRAIT);
            default:
                return this.getCounterClockwiseProps(orientation);
        }
    }
    getCounterClockwiseProps(orientation) {
        const windowWidth = this.resContainer.innerWidth;
        const windowHeight = this.resContainer.innerHeight;
        const angles = {
            [Orientation_1.default.LANDSCAPE]: {
                angle: 0,
                translateX: '0%',
                translateY: '0%',
                width: `${windowWidth}px`,
                height: `${windowHeight}px`,
            },
            [Orientation_1.default.PORTRAIT_FLIPPED]: {
                angle: 90,
                translateX: '0%',
                translateY: `-${windowWidth}px`,
                width: `${windowHeight}px`,
                height: `${windowWidth}px`,
            },
            [Orientation_1.default.LANDSCAPE_FLIPPED]: {
                angle: 180,
                translateX: `-${windowWidth}px`,
                translateY: `-${windowHeight}px`,
                width: `${windowWidth}px`,
                height: `${windowHeight}px`,
            },
            [Orientation_1.default.PORTRAIT]: {
                angle: 270,
                translateX: `-${windowHeight}px`,
                translateY: '0%',
                width: `${windowHeight}px`,
                height: `${windowWidth}px`,
            },
        };
        return angles[orientation];
    }
}
exports.default = ScreenRotationPixelPropsProvider;
//# sourceMappingURL=ScreenRotationPixelPropsProvider.js.map