import IVideoPlayer from '../../Video/IVideoPlayer';
import IStreamPlayer from '../../Stream/IStreamPlayer';
import IScreenRotationManager from './IScreenRotationManager';
import IScreenRotationPropsProvider from './IScreenRotationPropsProvider';
import { IHTMLElementProducer } from '../../HTML/IHTMLElementProducer';
import Orientation from '@signageos/common-types/dist/Device/Resolution/Orientation';
export default class ScreenRotationManager implements IScreenRotationManager {
    private window;
    private propsProvider;
    private elements;
    private getOrientation;
    constructor(window: Window, propsProvider: IScreenRotationPropsProvider, elements: HTMLElement[], getOrientation: () => Promise<Orientation>);
    applyOrientation(): Promise<void>;
    adaptVideoPlayer(videoPlayer: IVideoPlayer): IVideoPlayer;
    adaptStreamPlayer(streamPlayer: IStreamPlayer): IStreamPlayer;
    adaptHTMLElementProducer(htmlElementProducer: IHTMLElementProducer): IHTMLElementProducer;
    private applyOrientationToElements;
}
