import IVideoPlayer from '../../Video/IVideoPlayer';
import IStreamPlayer from '../../Stream/IStreamPlayer';
import { IHTMLElementProducer } from '../../HTML/IHTMLElementProducer';
interface IScreenRotationManager {
    applyOrientation(): Promise<void>;
    adaptVideoPlayer(videoPlayer: IVideoPlayer): IVideoPlayer;
    adaptStreamPlayer(streamPlayer: IStreamPlayer): IStreamPlayer;
    /**
     * Apply rotation to HTML elements produced by provided IHTMLElementProducer
     *
     * IHTMLElementProducer will produce HTML elements dynamically at runtime.
     * Calling this method will make IScreenRotationManager to apply rotation to these elements on the fly.
     */
    adaptHTMLElementProducer(htmlElementProducer: IHTMLElementProducer): IHTMLElementProducer;
}
export default IScreenRotationManager;
