import IStreamPlayer, { IStreamOptions, ITrackInfo, TrackType } from '../../Stream/IStreamPlayer';
import IStream from '../../Stream/IStream';
import { IVideoSrcArguments } from '../../Video/IVideoSrcArguments';
/**
 * Wrapper class for any implementation of stream player that converts CSS-rotated coordinates back to landscape for the system
 *
 * When the content is rotated via CSS, all the coordinates that are sent from it are rotated as well.
 * That's bad because from the point of view of the system it's landscape and the rotated coordinates don't make sense.
 * This is a proxy class that converts the coordinates between the client and the system so neither of them have to worry about it.
 */
export default class CSSRotationStreamPlayerAdapter implements IStreamPlayer {
    private window;
    private streamPlayer;
    private getAngle;
    constructor(window: Window, streamPlayer: IStreamPlayer, getAngle: () => Promise<number>);
    prepare(uri: string, x: number, y: number, width: number, height: number, options?: IStreamOptions): Promise<void>;
    play(uri: string, x: number, y: number, width: number, height: number, options?: IStreamOptions): Promise<IStream>;
    stop(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    pause(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    resume(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    clearAll(): Promise<void>;
    getTracks(videoId: IVideoSrcArguments): Promise<ITrackInfo[]>;
    selectTrack(videoId: IVideoSrcArguments, trackType: TrackType, groupId: string, trackIndex: number): Promise<any>;
    resetTrack(videoId: IVideoSrcArguments, trackType: TrackType, groupId?: string): Promise<any>;
    private convertEventEmitterWithConvertedCoordinatesBackToOriginalCoordinates;
}
