"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * A Power Action Timer that doesn't support persisting rules
 * and scheduling power actions (will throw error).
 */
class NotImplementedPowerActionTimer {
    /**
     * @throws Unsupported operation
     */
    set(_uid, _rule) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Unsupported operation');
        });
    }
    /**
     * @throws Unsupported operation
     */
    unset(..._uid) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Unsupported operation');
        });
    }
    /**
     * @throws Unsupported operation
     */
    reset() {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Unsupported operation');
        });
    }
    /**
     * @returns An empty set of rules
     */
    rules() {
        return __awaiter(this, void 0, void 0, function* () {
            return {};
        });
    }
    /**
     * Does nothing.
     */
    notifyStart() {
        return __awaiter(this, void 0, void 0, function* () {
            // No-op.
        });
    }
    /**
     * Does nothing.
     */
    notifyEnd() {
        return __awaiter(this, void 0, void 0, function* () {
            // No-op.
        });
    }
}
exports.default = NotImplementedPowerActionTimer;
//# sourceMappingURL=NotImplementedPowerActionTimer.js.map