import { PowerActionRule, PowerActionRules } from './IPowerActionTimer';
import IPowerActionTimerStorage from './IPowerActionTimerStorage';
import PowerActionTimerPropertyStorage from './PowerActionTimerPropertyStorage';
/**
 * Power Action Timer storage that copies rules from ``oldStorage`` to ``newStorage``
 * if ``newStorage`` hasn't been written to yet.
 *
 * Migration is ensured to run at most once before any method returns.
 */
export default class MigratingPowerActionTimerPropertyStorage implements IPowerActionTimerStorage {
    private readonly oldStorage;
    private readonly newStorage;
    /**
     * We want the migration done before any accessor runs and *only once*.
     * We don't care if it's lazy or eager.
     */
    private readonly migration;
    constructor(oldStorage: () => PowerActionTimerPropertyStorage, newStorage: PowerActionTimerPropertyStorage);
    put(uid: string, rule: PowerActionRule): Promise<void>;
    remove(uid: string): Promise<boolean>;
    clear(): Promise<boolean>;
    content(): Promise<PowerActionRules>;
    private performMigration;
}
