import PowerActionType from '@signageos/actions/dist/Device/Power/PowerActionType';
import Weekday from '@signageos/actions/dist/Misc/Weekday';
/**
 * An entry point for scheduling power actions.
 *
 * Implementations are in charge of:
 * * persisting Power Action Timer rules,
 * * scheduling power action timer execution according to those rules.
 */
export default interface IPowerActionTimer {
    /**
     * Remember a Power Action Timer rule and schedule power actions accordingly.
     * @param uid ID of the new rule
     * @param rule The new rule to remember
     */
    set(uid: string, rule: PowerActionRule): Promise<void>;
    /**
     * Forget a Power Action Timer rule and unschedule associated power actions.
     * @param uid ID of a rule to forget
     */
    unset(...uid: string[]): Promise<void>;
    /**
     * Forget all Power Action Timer rules and unschedule associated power actions.
     */
    reset(): Promise<void>;
    /**
     * @returns A list of known Power Action Timer rules
     */
    rules(): Promise<PowerActionRules>;
    /**
     * Call on start to schedule power actions based on persisted Power Action Timer rules.
     */
    notifyStart(): Promise<void>;
    /**
     * Call on end to cancel schedule. This doesn't affect persisted Power Action Timer rules.
     */
    notifyEnd(): Promise<void>;
}
export type PowerActionRule = {
    powerType: PowerActionType;
    weekdays: Weekday[];
    time: string;
};
export type PowerActionRules = {
    [uid: string]: PowerActionRule;
};
