"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLocalIpAddresses = void 0;
function getLocalIpAddresses(timeoutMs = 5e3) {
    return __awaiter(this, void 0, void 0, function* () {
        return new Promise((resolve) => {
            const RTCPeerConnection = 
            /*window.RTCPeerConnection ||*/ window.webkitRTCPeerConnection || window.mozRTCPeerConnection;
            if (RTCPeerConnection) {
                const allAddresses = [];
                (function () {
                    const rtc = new RTCPeerConnection({ iceServers: [] });
                    rtc.createDataChannel('', {
                        reliable: false,
                    });
                    rtc.onicecandidate = function (evt) {
                        // convert the candidate to SDP so we can run it through our general parser
                        // see https://twitter.com/lancestout/status/525796175425720320 for details
                        if (evt.candidate) {
                            grepSDP('a=' + evt.candidate.candidate);
                        }
                    };
                    rtc.createOffer((offerDesc) => {
                        grepSDP(offerDesc.sdp);
                        rtc.setLocalDescription(offerDesc);
                    }, (error) => {
                        console.warn('offer failed', error);
                    });
                    function grepSDP(sdp) {
                        const addressesCandidates = sdp.split('\r\n').map((line) => {
                            // c.f. http://tools.ietf.org/html/rfc4566#page-39
                            if (line.indexOf('a=candidate') !== -1) {
                                // http://tools.ietf.org/html/rfc4566#section-5.13
                                const parts = line.split(' '); // http://tools.ietf.org/html/rfc5245#section-15.1
                                const address = parts[4];
                                const type = parts[7];
                                if (type === 'host') {
                                    const priority = isLocalIpAddress(address) ? 5 : 3;
                                    return { priority, address };
                                }
                                else {
                                    return undefined;
                                }
                            }
                            else if (line.indexOf('c=') !== -1) {
                                // http://tools.ietf.org/html/rfc4566#section-5.7
                                const parts = line.split(' ');
                                const address = parts[2];
                                const priority = isLocalIpAddress(address) ? 4 : 2;
                                return { priority, address };
                            }
                            else {
                                return undefined;
                            }
                        });
                        const validatedAddresses = addressesCandidates.filter((addr) => addr);
                        allAddresses.push(...validatedAddresses);
                    }
                })();
                setTimeout(() => resolve(allAddresses
                    .sort((a, b) => b.priority - a.priority)
                    .map((addressObject) => addressObject.address)), timeoutMs);
            }
            else {
                resolve([]);
            }
        });
    });
}
exports.getLocalIpAddresses = getLocalIpAddresses;
function isLocalIpAddress(address) {
    return address.startsWith('192.168.') || address.startsWith('10.') || address.startsWith('172.');
}
//# sourceMappingURL=ipAddressHelper.js.map