import INetwork from '../Network/INetwork';
import ManagementCapability from './ManagementCapability';
import IBatteryStatus from '../Battery/IBatteryStatus';
import IFileSystem from '../IFileSystem';
import IBrightness from '../IBrightness';
import { ResolutionItem } from '../ResolutionList';
import IServletRunner from '../../Servlet/IServletRunner';
import NativeFromDriverTimer from '../Timer/ITimer';
import NumberTimerType from '../Timer/TimerType';
import TimerWeekday from '@signageos/lib/dist/Timer/Power/PowerTimerWeekday';
import IProximitySensor from '../Sensors/IProximitySensor';
import IMonitors from '../IMonitors';
import IWifi from '../Hardware/IWifi';
import ISystemInfo from '../ISystemInfo';
import Orientation from '@signageos/common-types/dist/Device/Resolution/Orientation';
import VideoOrientation from '@signageos/common-types/dist/Device/Resolution/VideoOrientation';
import IProxy from '../Network/IProxy';
import { IAutoRecoveryConfiguration, IAutoRecoverySettings } from '../IAutoRecovery';
import { IPeerRecoveryConfiguration, IPeerRecoverySettings } from '../IPeerRecovery';
import ITimeManager from '../TimeManager/ITimeManager';
import { IInput } from '../Input/IInput';
import IBasicDriver from '../IBasicDriver';
import { IVpn } from '../VPN/IVpn';
import { IProprietaryTimerStorage } from '../../Timer/ITimerStorage';
import { IMdc } from '../NativeCommand/MDC/IMdc';
import { IScripts } from '../CustomScripts/IScripts';
import IDisplayManager from '../DisplayManager/IDisplayManager';
import { SecretManager } from '../../Management/Secrets/SecretManager';
import { PowerExecutors } from '../../Management/Device/Power/powerExecutors';
export interface ISensors {
    proximity: IProximitySensor;
}
export interface INativeCommands {
    mdc: IMdc;
}
/**
 * Platform specific APIs that can be injected into browser's iframe for custom scripts execution.
 * Provide an object with key-value pairs where key is the name of the API and value is the object that should be injected alongside signageOS APIs.
 */
export type IPlatformSpecificAPIs = Record<string, object>;
/**
 * Callback that should be called after changing debug settings to perform platform specific operations that will
 * finalize the debug settings change.
 */
export type SetDebugFinalizeCallback = () => Promise<void>;
export interface IFrontManagementDriver extends IBasicDriver {
    timeManager: Pick<ITimeManager, 'getEpochMillis'>;
    systemInfo: Pick<ISystemInfo, 'getModel' | 'getSerialNumber' | 'getBrand' | 'getOSVersion'>;
    secretManager: Pick<SecretManager, 'decryptJweGeneralToUtf8' | 'generateKeys'>;
    proxy: Pick<IProxy, 'isEnabled' | 'getConnectedTo'>;
    wifi: Pick<IWifi, 'on' | 'disconnect' | 'disable'>;
    sensors: {
        proximity: Pick<ISensors['proximity'], 'addStateChangeListener'>;
    };
    fileSystem: IFileSystem;
    network: Pick<INetwork, 'listInterfaces'>;
    powerExecutors: PowerExecutors;
    isDebugEnabled(): Promise<boolean>;
    managementSupports(capability: ManagementCapability): Promise<boolean>;
    firmwareGetVersion(): Promise<string>;
    /**
     * Type is related to firmware version binary file. null means that FW file is independent.
     * TODO once all drivers supports firmware type, null can be removed
     */
    firmwareGetType(): Promise<string | null>;
}
export default interface IManagementDriver extends IFrontManagementDriver {
    systemInfo: ISystemInfo;
    sensors: ISensors;
    monitors: IMonitors;
    network: INetwork;
    wifi: IWifi;
    proxy: IProxy;
    vpn: IVpn;
    servletRunner: IServletRunner;
    timeManager: ITimeManager;
    input: IInput;
    proprietaryTimerStorage: IProprietaryTimerStorage;
    /**
     * Platform specific APIs that can be injected into browser's iframe for custom scripts execution.
     * Provide an object with key-value pairs where key is the name of the API and value is the object that should be injected alongside signageOS APIs.
     */
    platformSpecificAPIs: IPlatformSpecificAPIs;
    nativeCommands: INativeCommands;
    scripts: IScripts;
    secretManager: SecretManager;
    displayManager: IDisplayManager;
    initialize(staticBaseUrl: string): Promise<void>;
    getApplicationType(): string;
    appUpgrade(baseUrl: string, version?: string): Promise<() => Promise<void>> | Promise<void>;
    batteryGetStatus(): Promise<IBatteryStatus>;
    getCurrentTemperature(): Promise<number>;
    screenshotUpload(uploadBaseUrl: string, computeHash?: boolean): Promise<{
        url: string;
        imageInformations?: {
            aHash?: string;
            dHash?: string;
        };
    }>;
    firmwareUpgrade(baseUrl: string, version?: string, onProgress?: (progress: number) => void): Promise<() => Promise<void>> | Promise<void>;
    getVolume(): Promise<number>;
    setVolume(volume: number): Promise<void>;
    screenSetBrightness(timeFrom1: string, brightness1: number, timeFrom2: string, brightness2: number): Promise<void>;
    screenGetBrightness(): Promise<IBrightness>;
    packageInstall(baseUrl: string, packageName: string, version: string, build: string | null): Promise<void>;
    systemReboot(): Promise<void>;
    appRestart(): void;
    displayPowerOn(): Promise<void>;
    displayPowerOff(): Promise<void>;
    displayIsPowerOn(): Promise<boolean>;
    screenResize(baseUrl: string, orientation: Orientation, resolution: ResolutionItem, currentVersion: string, videoOrientation?: VideoOrientation): Promise<() => Promise<void>> | Promise<void>;
    getCurrentOrientation(): Promise<Orientation>;
    setOrientation(baseUrl: string, orientation: Orientation, videoOrientation?: VideoOrientation): Promise<() => Promise<void>> | Promise<void>;
    setResolution(resolution: ResolutionItem): Promise<() => Promise<void>> | Promise<void>;
    getResolution(): Promise<ResolutionItem>;
    getTimers(): Promise<NativeFromDriverTimer[]>;
    setTimer(type: NumberTimerType, timeOn: string | null, timeOff: string | null, weekdays: TimerWeekday[], volume: number): Promise<void>;
    remoteControlSetEnabled(enabled: boolean): Promise<() => Promise<void>> | Promise<void>;
    remoteControlIsEnabled(): Promise<boolean>;
    /**
     * Enables/disables native debug
     *
     * Meaning of native debug may differ based on the platform and
     * it's necessary to check the documentation for how to debug the specific platform.
     *
     * Some platforms require the device to be rebooted after enabling/disabling native debug.
     * Because of that, this method may return a finalize callback.
     * Finalize callback shouldn't be called immediately after this method.
     * Instead, additional steps should be done that need to be done after changing debug settings but before potential reboot.
     * For example, if the request to change debug settings came from the server,
     * the device would first need to report the result of the operation to the server before rebooting,
     * otherwise the server wouldn't know if the operation was successful or not.
     *
     * @param enabled Whether to enable or disable native debug
     * @returns May optionally return a callback that should be called after any additional cleanup
     */
    setDebug(enabled: boolean): Promise<void | SetDebugFinalizeCallback>;
    resetSettings(): Promise<void>;
    factoryReset(): Promise<void>;
    getSupportedResolutions(): Promise<ResolutionItem[]>;
    getExtendedManagementUrl(): Promise<string | null>;
    /**
     * Setup URL to extended management server (e.g.: magicInfoUrl)
     * Setting to null will disable extended management control
     */
    setExtendedManagementUrl(extendedManagementUrl: string | null): Promise<() => Promise<void>> | Promise<void>;
    getAutoRecovery(): Promise<IAutoRecoverySettings>;
    setAutoRecovery(configuration: IAutoRecoveryConfiguration): Promise<void>;
    getPeerRecovery(): Promise<IPeerRecoverySettings>;
    setPeerRecovery(configuration: IPeerRecoveryConfiguration): Promise<void>;
    /**
     * Returns true, if management can detect that core app has active front for content.
     */
    isFrontEnabled(): Promise<boolean>;
    /**
     * Enable or disable hardware acceleration on the device.</br>
     * Linked capability: `HARDWARE_ACCELERATION`
     *
     * @param enable Boolean
     * @returns Promise<void>
     */
    setHardwareAcceleration(enable: boolean): Promise<void>;
    /**
     * Check if hardware acceleration is enabled on the device.
     * @returns Promise<boolean>
     */
    isHardwareAccelerationEnabled(): Promise<boolean>;
}
