"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.keyboardKeyMap = exports.KeyCode = void 0;
// Number values are important because it's part of public API
var KeyCode;
(function (KeyCode) {
    KeyCode[KeyCode["UNKNOWN"] = -1] = "UNKNOWN";
    KeyCode[KeyCode["NUM_0"] = 0] = "NUM_0";
    KeyCode[KeyCode["NUM_1"] = 1] = "NUM_1";
    KeyCode[KeyCode["NUM_2"] = 2] = "NUM_2";
    KeyCode[KeyCode["NUM_3"] = 3] = "NUM_3";
    KeyCode[KeyCode["NUM_4"] = 4] = "NUM_4";
    KeyCode[KeyCode["NUM_5"] = 5] = "NUM_5";
    KeyCode[KeyCode["NUM_6"] = 6] = "NUM_6";
    KeyCode[KeyCode["NUM_7"] = 7] = "NUM_7";
    KeyCode[KeyCode["NUM_8"] = 8] = "NUM_8";
    KeyCode[KeyCode["NUM_9"] = 9] = "NUM_9";
    KeyCode[KeyCode["ARROW_LEFT"] = 10] = "ARROW_LEFT";
    KeyCode[KeyCode["ARROW_UP"] = 11] = "ARROW_UP";
    KeyCode[KeyCode["ARROW_RIGHT"] = 12] = "ARROW_RIGHT";
    KeyCode[KeyCode["ARROW_DOWN"] = 13] = "ARROW_DOWN";
    KeyCode[KeyCode["OK"] = 14] = "OK";
    KeyCode[KeyCode["YELLOW"] = 15] = "YELLOW";
    KeyCode[KeyCode["BLUE"] = 16] = "BLUE";
    KeyCode[KeyCode["RED"] = 17] = "RED";
    KeyCode[KeyCode["GREEN"] = 18] = "GREEN";
    KeyCode[KeyCode["VOLUME_DOWN"] = 19] = "VOLUME_DOWN";
    KeyCode[KeyCode["VOLUME_UP"] = 20] = "VOLUME_UP";
    KeyCode[KeyCode["POWER"] = 21] = "POWER";
    KeyCode[KeyCode["POWER_OFF"] = 22] = "POWER_OFF";
    KeyCode[KeyCode["HOME"] = 23] = "HOME";
    KeyCode[KeyCode["EXIT"] = 24] = "EXIT";
    KeyCode[KeyCode["RETURN"] = 25] = "RETURN";
    KeyCode[KeyCode["BACKSPACE"] = 26] = "BACKSPACE";
    KeyCode[KeyCode["LOCK"] = 27] = "LOCK";
    KeyCode[KeyCode["BACKWARD"] = 28] = "BACKWARD";
    KeyCode[KeyCode["FORWARD"] = 29] = "FORWARD";
    KeyCode[KeyCode["PLAY"] = 30] = "PLAY";
    KeyCode[KeyCode["PAUSE"] = 31] = "PAUSE";
    KeyCode[KeyCode["STOP"] = 32] = "STOP";
    KeyCode[KeyCode["PLAY_PAUSE"] = 33] = "PLAY_PAUSE";
    KeyCode[KeyCode["VOLUME_MUTE"] = 34] = "VOLUME_MUTE";
    KeyCode[KeyCode["CHANNEL_UP"] = 35] = "CHANNEL_UP";
    KeyCode[KeyCode["CHANNEL_DOWN"] = 36] = "CHANNEL_DOWN";
    // https://developer.samsung.com/smarttv/develop/guides/user-interaction/remote-control.html
    KeyCode[KeyCode["MEDIA_TRACK_NEXT"] = 37] = "MEDIA_TRACK_NEXT";
    KeyCode[KeyCode["MEDIA_TRACK_PREVIOUS"] = 38] = "MEDIA_TRACK_PREVIOUS";
    // Sony RMF-TX520U, Sony RMT-TB400U
    // PERIOD = 39, // Reserved.
    /** Record media key. */
    KeyCode[KeyCode["MEDIA_RECORD"] = 40] = "MEDIA_RECORD";
    /** Info key. Common on TV remotes to show additional information related to what is currently being viewed. */
    KeyCode[KeyCode["INFO"] = 41] = "INFO";
    /** Guide key. On TV remotes, shows a programming guide. */
    KeyCode[KeyCode["GUIDE"] = 42] = "GUIDE";
    /** Toggle captions key. Switches the mode for closed-captioning text, for example during television shows. */
    KeyCode[KeyCode["CAPTIONS"] = 43] = "CAPTIONS";
    /** Audio Track key. Switches the audio tracks. */
    KeyCode[KeyCode["MEDIA_AUDIO_TRACK"] = 44] = "MEDIA_AUDIO_TRACK";
})(KeyCode || (exports.KeyCode = KeyCode = {}));
exports.keyboardKeyMap = {
    '0': KeyCode.NUM_0,
    '1': KeyCode.NUM_1,
    '2': KeyCode.NUM_2,
    '3': KeyCode.NUM_3,
    '4': KeyCode.NUM_4,
    '5': KeyCode.NUM_5,
    '6': KeyCode.NUM_6,
    '7': KeyCode.NUM_7,
    '8': KeyCode.NUM_8,
    '9': KeyCode.NUM_9,
    Enter: KeyCode.OK,
    Backspace: KeyCode.RETURN,
    Escape: KeyCode.EXIT,
    ArrowUp: KeyCode.ARROW_UP,
    ArrowDown: KeyCode.ARROW_DOWN,
    ArrowLeft: KeyCode.ARROW_LEFT,
    ArrowRight: KeyCode.ARROW_RIGHT,
    Home: KeyCode.HOME,
    Q: KeyCode.YELLOW,
    W: KeyCode.YELLOW,
    E: KeyCode.RED,
    R: KeyCode.GREEN,
    F9: KeyCode.POWER_OFF,
    F10: KeyCode.POWER,
};
//# sourceMappingURL=KeyCode.js.map