export declare enum KeyCode {
    UNKNOWN = -1,
    NUM_0 = 0,
    NUM_1 = 1,
    NUM_2 = 2,
    NUM_3 = 3,
    NUM_4 = 4,
    NUM_5 = 5,
    NUM_6 = 6,
    NUM_7 = 7,
    NUM_8 = 8,
    NUM_9 = 9,
    ARROW_LEFT = 10,
    ARROW_UP = 11,
    ARROW_RIGHT = 12,
    ARROW_DOWN = 13,
    OK = 14,
    YELLOW = 15,
    BLUE = 16,
    RED = 17,
    GREEN = 18,
    VOLUME_DOWN = 19,
    VOLUME_UP = 20,
    POWER = 21,
    POWER_OFF = 22,
    HOME = 23,
    EXIT = 24,
    RETURN = 25,
    BACKSPACE = 26,
    LOCK = 27,
    BACKWARD = 28,
    FORWARD = 29,
    PLAY = 30,
    PAUSE = 31,
    STOP = 32,
    PLAY_PAUSE = 33,
    VOLUME_MUTE = 34,
    CHANNEL_UP = 35,
    CHANNEL_DOWN = 36,
    MEDIA_TRACK_NEXT = 37,
    MEDIA_TRACK_PREVIOUS = 38,
    /** Record media key. */
    MEDIA_RECORD = 40,
    /** Info key. Common on TV remotes to show additional information related to what is currently being viewed. */
    INFO = 41,
    /** Guide key. On TV remotes, shows a programming guide. */
    GUIDE = 42,
    /** Toggle captions key. Switches the mode for closed-captioning text, for example during television shows. */
    CAPTIONS = 43,
    /** Audio Track key. Switches the audio tracks. */
    MEDIA_AUDIO_TRACK = 44
}
export declare const keyboardKeyMap: {
    [key: string]: KeyCode;
};
