export interface ISystemMemory {
    /**
     * Represents used system memory in bytes.
     */
    used: number;
    /**
     * Represents total system memory in bytes.
     */
    total: number;
    /**
     * Represents free memory in bytes.
     */
    free: number;
}
export default interface ISystemInfo {
    getModel(): Promise<string>;
    getSerialNumber(): Promise<string>;
    getOSVersion(): Promise<string>;
    /**
     * Returns actual CPU usage
     * @returns {number} number - Should be value from 0 to 100
     */
    getCpuUsage(): Promise<number>;
    getMemoryUsage(): Promise<ISystemMemory>;
    getBrand(): Promise<string>;
    getOsName(): Promise<string>;
}
