type Color = string;
export type ITheme = {
    base?: 'light' | 'dark';
    shape?: {
        cornerSize?: number;
    };
    colors?: {
        primary?: Color;
        background?: Color;
        control?: Color;
    };
    widgets?: {
        editAddress?: {
            colors?: {
                background?: Color;
                text?: Color;
            };
        };
        buttonClose?: {
            colors?: {
                background?: Color | '@primary';
                text?: Color;
                icon?: Color;
            };
            icon?: 'none' | 'exit_to_app' | 'close' | 'cancel';
            text?: string;
        };
        progress?: {
            color?: Color | '@primary';
        };
    };
};
export interface IOpenLinkOptions {
    aclDomains?: string[];
    aclMode?: 'blacklist' | 'whitelist';
    readOnlyAddressBar?: boolean;
    idleTimeout?: number;
    coordinates?: {
        x: number;
        y: number;
        width: number;
        height: number;
    };
    theme?: ITheme;
    headlessMode?: boolean;
    clearData?: boolean;
    canUserClose?: boolean;
    method?: string;
}
export declare enum EventType {
    CLOSE = "close"
}
export type Event<TType extends EventType = EventType> = {
    type: TType;
};
export interface CloseEvent extends Event<EventType.CLOSE> {
    reason: CloseReason;
}
export declare enum CloseReason {
    API = "API",
    USER = "USER",
    TIMEOUT = "TIMEOUT"
}
export default interface IBrowser {
    open(uri: string, options?: IOpenLinkOptions): Promise<void>;
    close(): Promise<void>;
    /**
     * Find out when the browser is closed.
     * This doesn't fire between `open` calls or on subsequent `close` calls.
     */
    addListener<TType extends EventType>(type: TType, listener: (event: Event<TType>) => void): void;
    removeListener<TType extends EventType>(type: TType, listener: (event: Event<TType>) => void): void;
    isSupported(): Promise<boolean>;
}
export {};
