export interface IWifiDevice {
    ssid: string;
    encrypted: boolean;
    strength: number;
}
export declare enum WifiEvent {
    CLIENT_ENABLED = "client_enabled",
    CLIENT_CONNECTED = "client_connected",
    CLIENT_CONNECT_REJECTED = "client_connect_rejected",
    CLIENT_DISCONNECTED = "client_disconnected",
    AP_ENABLED = "ap_enabled",
    DISABLED = "disabled"
}
export type WifiEncryptionType = 'OPEN' | 'WEP' | 'WPA2' | 'WPA2_WPA_MIXED' | 'WPA3' | '802.1X_EAP';
export interface IWifiConnectOptions {
    hidden?: boolean;
    securityType?: WifiEncryptionType;
}
export default interface IWifi {
    isClientEnabled(): Promise<boolean>;
    enableClient(): Promise<void>;
    isAPEnabled(): Promise<boolean>;
    enableAP(ssid: string, passphrase: string): Promise<void>;
    disable(): Promise<void>;
    connect(ssid: string, password?: string, options?: IWifiConnectOptions): Promise<void>;
    disconnect(): Promise<void>;
    getConnectedTo(): Promise<IWifiDevice | null>;
    getCountry(): Promise<string | null>;
    setCountry(countryCode: string): Promise<void>;
    scan(): Promise<IWifiDevice[]>;
    on(event: WifiEvent, listener: (...args: any[]) => void): void;
    once(event: WifiEvent, listener: (...args: any[]) => void): void;
    removeListener(event: WifiEvent, listener: (...args: any[]) => void): void;
    removeAllListeners(event?: WifiEvent): void;
}
