import IKeyUpEvent from '../Input/IKeyUpEvent';
import ISignature from '../ISignature';
import IVideoPlayer from '../../Video/IVideoPlayer';
import IStreamPlayer from '../../Stream/IStreamPlayer';
import IBasicDriver from '../IBasicDriver';
import FrontCapability from './FrontCapability';
import IFileSystem from '../IFileSystem';
import ILed from '../Hardware/ILed';
import ISerial from '../Hardware/ISerial';
import IBarcodeScanner from '../Hardware/IBarcodeScanner';
import IBrowser from '../IBrowser';
import ITouchEventMessage from './ITouchEventMessage';
import ISecurity from '../../Front/Security/ISecurity';
import { IProprietaryTimerStorage } from '../../Timer/ITimerStorage';
export interface Hardware {
    led: ILed;
    serial: ISerial;
    barcodeScanner: IBarcodeScanner;
}
/** @deprecated */
export interface IOpenLinkOptions {
    acl?: RegExp[];
    aclMode?: 'blacklist' | 'whitelist';
    readOnlyAddressBar?: boolean;
    idleTimeout?: number;
}
interface IFrontDriver extends IBasicDriver {
    hardware: Hardware;
    video: IVideoPlayer;
    stream: IStreamPlayer;
    fileSystem: IFileSystem;
    browser: IBrowser;
    security: ISecurity;
    proprietaryTimerStorage: IProprietaryTimerStorage;
    forwardTouchEvents: (callback: (message: ITouchEventMessage) => void) => void;
    frontSupports(capability: FrontCapability): Promise<boolean>;
    isDetected(): boolean;
    bindKeyUp(keyUpListener: (keyUpEvent: IKeyUpEvent) => void): void;
    remoteControlSetEnabled(enabled: boolean): Promise<() => Promise<void>> | Promise<void>;
    remoteControlIsEnabled(): Promise<boolean>;
    restoreDisplayArea(): Promise<void>;
    /** @deprecated Implement `security`. */
    controlSetPin(pin: string): Promise<void>;
    /** @deprecated use browser instead */
    browserOpenLink(uri: string, options?: IOpenLinkOptions): Promise<void>;
    getCurrentSignature(): Promise<ISignature | null>;
    getOSDUri(): string;
}
export default IFrontDriver;
