"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotSupportedMethodError = void 0;
class NotSupportedMethodError extends Error {
    constructor(methodName) {
        super(`${methodName} is not supported`);
        // https://github.com/Microsoft/TypeScript/wiki/Breaking-Changes#extending-built-ins-like-error-array-and-map-may-no-longer-work
        Object.setPrototypeOf(this, NotSupportedMethodError.prototype);
    }
}
exports.NotSupportedMethodError = NotSupportedMethodError;
//# sourceMappingURL=basicErrors.js.map