"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDefaultDrivers = void 0;
const ScreenRotationManager_1 = __importDefault(require("../Screen/ScreenRotationManager"));
const IframeBrowser_1 = __importDefault(require("../../Browser/IframeBrowser"));
const DefaultSettingsManager_1 = __importDefault(require("./DefaultSettingsManager"));
const ProprietaryStreamPlayer_1 = __importDefault(require("../../Stream/ProprietaryStreamPlayer"));
const HTMLVideoPlayer_1 = __importDefault(require("../../Video/HTMLVideoPlayer"));
const ReconnectStreamPlayer_1 = __importDefault(require("../../Stream/ReconnectStreamPlayer"));
const ScreenRotationViewportPropsProvider_1 = __importDefault(require("../Screen/ScreenRotationViewportPropsProvider"));
const DefaultBasicDriver_1 = require("./DefaultBasicDriver");
const DefaultCacheDriver_1 = __importDefault(require("./DefaultCacheDriver"));
const DefaultFrontDriver_1 = require("./DefaultFrontDriver");
const DefaultManagementDriver_1 = require("./DefaultManagementDriver");
const CategorizedLocalStorage_1 = __importDefault(require("../../Storage/CategorizedLocalStorage"));
const getEmulatorUid_1 = require("./getEmulatorUid");
const browserFileSystemFactory_1 = require("../../FileSystem/browserFileSystemFactory");
const MAX_ALLOWED_VIDEOS = 4;
/**
 * @param storageBaseUrl The Base URL of where the cacheStorage is located (prefixed) accessible for serviceWorker.
 * There is a limitation for the scope of serviceWorker that it can by max in the same directory as the serviceWorker JS file.
 * So all cached files has to be stored inside the same directory or subdirectories. Otherwise the cache wouldn't work.
 * By default, it's set to current origin but it should be rather filled anyway.
 */
function createDefaultDrivers(window, storageBaseUrl = window.location.origin) {
    const foregroundVideosWrapperElement = createForegroundVideosWrapperElement(window);
    const backgroundVideosWrapperElement = createBackgroundVideosWrapperElement(window);
    const settingsManager = new DefaultSettingsManager_1.default(window);
    const screenRotationManager = createScreenRotationManager(window, settingsManager, [
        foregroundVideosWrapperElement,
        backgroundVideosWrapperElement,
    ]);
    const browser = createBrowser(window, screenRotationManager);
    const { videoPlayer, streamPlayer } = createVideoAndStreamPlayers(window, screenRotationManager, settingsManager, foregroundVideosWrapperElement, backgroundVideosWrapperElement);
    const deviceUid = (0, getEmulatorUid_1.getEmulatorUid)(window.location.href);
    const realFileSystem = (0, browserFileSystemFactory_1.createBrowserFileSystem)(window, deviceUid, storageBaseUrl);
    const storage = new CategorizedLocalStorage_1.default(window.localStorage, deviceUid);
    const basicDriver = new DefaultBasicDriver_1.DefaultBasicDriver(window, deviceUid);
    const cacheDriver = new DefaultCacheDriver_1.default(storage);
    const frontDriver = new DefaultFrontDriver_1.DefaultFrontDriver(window, videoPlayer, streamPlayer, browser, basicDriver, cacheDriver, storage, realFileSystem);
    const managementDriver = new DefaultManagementDriver_1.DefaultManagementDriver(window, deviceUid, settingsManager, screenRotationManager, cacheDriver, basicDriver, realFileSystem);
    return { frontDriver, managementDriver, cacheDriver };
}
exports.createDefaultDrivers = createDefaultDrivers;
function createForegroundVideosWrapperElement(window) {
    const HTML_ELEMENT_ID = 'videos-wrapper-foreground';
    const videosWrapper = window.document.createElement('div');
    videosWrapper.id = HTML_ELEMENT_ID;
    videosWrapper.setAttribute('class', 'video-wrapper');
    window.document.body.appendChild(videosWrapper);
    return videosWrapper;
}
function createBackgroundVideosWrapperElement(window) {
    const HTML_ELEMENT_ID = 'videos-wrapper-background';
    const videosWrapper = window.document.createElement('div');
    videosWrapper.id = HTML_ELEMENT_ID;
    videosWrapper.setAttribute('class', 'video-wrapper');
    window.document.body.appendChild(videosWrapper);
    return videosWrapper;
}
function createScreenRotationManager(window, settingsManager, videosWrapperElements) {
    const bodyElement = window.document.getElementById('body');
    const elementsToRotate = [bodyElement];
    if (!isFakePortrait(settingsManager)) {
        elementsToRotate.push(...videosWrapperElements);
    }
    const propsProvider = new ScreenRotationViewportPropsProvider_1.default(false);
    return new ScreenRotationManager_1.default(window, propsProvider, elementsToRotate, () => __awaiter(this, void 0, void 0, function* () { return settingsManager.getOrientation(); }));
}
function createBrowser(window, screenRotationManager) {
    const browser = new IframeBrowser_1.default(window);
    return screenRotationManager.adaptHTMLElementProducer(browser);
}
function createVideoAndStreamPlayers(window, screenRotationManager, settingsManager, foregroundVideosWrapperElement, backgroundVideosWrapperElement) {
    const videoPlayer = new HTMLVideoPlayer_1.default(MAX_ALLOWED_VIDEOS, window, foregroundVideosWrapperElement, backgroundVideosWrapperElement, () => __awaiter(this, void 0, void 0, function* () { return settingsManager.getVolume(); }));
    settingsManager.onVolumeChange((volume) => videoPlayer.setVolume(volume));
    const streamPlayer = new ReconnectStreamPlayer_1.default(new ProprietaryStreamPlayer_1.default(videoPlayer));
    if (isFakePortrait(settingsManager)) {
        return {
            videoPlayer: screenRotationManager.adaptVideoPlayer(videoPlayer),
            streamPlayer: screenRotationManager.adaptStreamPlayer(streamPlayer),
        };
    }
    else {
        return { videoPlayer, streamPlayer };
    }
}
function isFakePortrait(settingsManager) {
    const videoOrientation = settingsManager.getVideoOrientation();
    return videoOrientation !== null;
}
//# sourceMappingURL=defaultDriverFactory.js.map