import DefaultCacheDriver from './DefaultCacheDriver';
import { DefaultFrontDriver } from './DefaultFrontDriver';
import { DefaultManagementDriver } from './DefaultManagementDriver';
/**
 * @param storageBaseUrl The Base URL of where the cacheStorage is located (prefixed) accessible for serviceWorker.
 * There is a limitation for the scope of serviceWorker that it can by max in the same directory as the serviceWorker JS file.
 * So all cached files has to be stored inside the same directory or subdirectories. Otherwise the cache wouldn't work.
 * By default, it's set to current origin but it should be rather filled anyway.
 */
export declare function createDefaultDrivers(window: Window, storageBaseUrl?: string): {
    frontDriver: DefaultFrontDriver;
    managementDriver: DefaultManagementDriver;
    cacheDriver: DefaultCacheDriver;
};
