"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultManagementDriver = void 0;
const convertWeekday_1 = require("@signageos/lib/dist/Timer/convertWeekday");
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const html2canvas_1 = __importDefault(require("html2canvas"));
const js_cookie_1 = __importDefault(require("js-cookie"));
const lodash_1 = __importDefault(require("lodash"));
const ProprietaryCache_1 = __importDefault(require("../../Cache/ProprietaryCache"));
const FileSystemWithReservedSpace_1 = require("../../FileSystem/FileSystemWithReservedSpace");
const fileSystemHelper_1 = require("../../FileSystem/fileSystemHelper");
const MockDeviceFirmwareVersion_1 = __importDefault(require("../../Firmware/MockDeviceFirmwareVersion"));
const MockWifi_1 = __importDefault(require("../../Hardware/MockWifi"));
const ProprietaryInput_1 = require("../../Input/ProprietaryInput");
const MockNetwork_1 = __importDefault(require("../../Management/Device/Network/MockNetwork"));
const MockMonitors_1 = __importDefault(require("../../Monitors/MockMonitors"));
const propertyStorage_1 = __importDefault(require("../../Property/propertyStorage"));
const overlayHelper_1 = require("../../Screen/overlayHelper");
const MockProximitySensor_1 = __importDefault(require("../../Sensors/MockProximitySensor"));
const NotImplementedServletRunner_1 = __importDefault(require("../../Servlet/NotImplementedServletRunner"));
const asyncStorageHelper_1 = require("../../Storage/Async/asyncStorageHelper");
const CategorizedLocalStorage_1 = __importDefault(require("../../Storage/CategorizedLocalStorage"));
const WebBrowserEmulatorSystemInfo_1 = __importDefault(require("../../SystemInfo/WebBrowserEmulatorSystemInfo"));
const ProprietaryTimerPropertyStorage_1 = __importDefault(require("../../Timer/ProprietaryTimerPropertyStorage"));
const batteryHelper_1 = require("../Battery/batteryHelper");
const ManagementCapability_1 = __importDefault(require("../Management/ManagementCapability"));
const NotImplementedMdc_1 = __importDefault(require("../NativeCommand/MDC/NotImplementedMdc"));
const NotImplementedProxy_1 = require("../Network/NotImplementedProxy");
const ResolutionList_1 = require("../ResolutionList");
const EmulatorTimeManager_1 = __importDefault(require("../TimeManager/EmulatorTimeManager"));
const TimerType_1 = __importStar(require("../Timer/TimerType"));
const ActionTimer_1 = __importDefault(require("./ActionTimer"));
const MockDisplayManager_1 = __importDefault(require("../DisplayManager/MockDisplayManager"));
const ManagementCapabilities_1 = require("@signageos/common-types/dist/Device/Capabilities/ManagementCapabilities");
const SubtleCryptoSecretManager_1 = __importDefault(require("../../Management/Secrets/SubtleCryptoSecretManager"));
const NotImplementedScripts_1 = __importDefault(require("../CustomScripts/NotImplementedScripts"));
const powerExecutors_1 = require("../../Management/Device/Power/powerExecutors");
const DefaultBrowserSecretStorage_1 = __importDefault(require("../../Management/Secrets/DefaultBrowserSecretStorage"));
class DefaultManagementDriver {
    constructor(window, deviceUid, settingsManager, screenRotationManager, cacheDriver, basicDriver, realFileSystem) {
        this.window = window;
        this.deviceUid = deviceUid;
        this.cacheDriver = cacheDriver;
        this.basicDriver = basicDriver;
        this.realFileSystem = realFileSystem;
        this.proxy = new NotImplementedProxy_1.NotImplementedProxy();
        this.platformSpecificAPIs = {};
        const DEFAULT_TOTAL_SIZE_BYTES = 5 * 1024 * 1024; // Default quota of localStorage in browsers
        this.input = new ProprietaryInput_1.ProprietaryInput(this.window);
        this.storage = new CategorizedLocalStorage_1.default(this.window.localStorage, deviceUid);
        this.asyncStorage = (0, asyncStorageHelper_1.asynchronizeStorage)(this.storage);
        this.cache = new ProprietaryCache_1.default(this.storage, DEFAULT_TOTAL_SIZE_BYTES);
        this.fileSystem = (0, FileSystemWithReservedSpace_1.createFileSystemWithReservedSpaceWithWindowHttpHeadFetcher)(this.realFileSystem, this.window, fileSystemHelper_1.RESERVED_SPACE_PERCENTAGE);
        this.settingsManager = settingsManager;
        this.screenRotationManager = screenRotationManager;
        this.servletRunner = new NotImplementedServletRunner_1.default();
        this.sensors = {
            proximity: new MockProximitySensor_1.default(this.window),
        };
        this.monitors = new MockMonitors_1.default(this.window);
        this.network = new MockNetwork_1.default(this.window);
        this.wifi = new MockWifi_1.default();
        this.systemInfo = new WebBrowserEmulatorSystemInfo_1.default(this.window);
        this.timeManager = new EmulatorTimeManager_1.default(this.window);
        this.proprietaryTimerStorage = new ProprietaryTimerPropertyStorage_1.default((0, propertyStorage_1.default)(() => this.cacheDriver));
        this.internalActionTimers = {
            autoRecovery: new ActionTimer_1.default(this.asyncStorage, 'autoRecovery', () => __awaiter(this, void 0, void 0, function* () {
                const storedRaw = yield this.asyncStorage.getItem(DefaultManagementDriver.AUTO_RECOVERY_KEY);
                const healthcheckIntervalMs = storedRaw
                    ? JSON.parse(storedRaw).healthcheckIntervalMs
                    : DefaultManagementDriver.AUTO_RECOVERY_DEFAULT_HEALTHCHECK_INTERVAL_MS;
                console.log(`Device auto recovery automatically enabled with healthcheck interval ${healthcheckIntervalMs}ms.`);
                yield this.setAutoRecovery({ enabled: true, healthcheckIntervalMs });
            })),
            peerRecovery: new ActionTimer_1.default(this.asyncStorage, 'peerRecovery', () => __awaiter(this, void 0, void 0, function* () {
                const storedRaw = yield this.asyncStorage.getItem(DefaultManagementDriver.PEER_RECOVERY_KEY);
                const urlLauncherAddress = storedRaw ? JSON.parse(storedRaw).urlLauncherAddress : this.getConfigurationBaseUrl();
                console.log(`Device peer recovery automatically enabled with URL launcher address ${urlLauncherAddress}.`);
                yield this.setPeerRecovery({ enabled: true, urlLauncherAddress });
            })),
        };
        this.nativeCommands = {
            mdc: new NotImplementedMdc_1.default(),
        };
        this.scripts = new NotImplementedScripts_1.default();
        this.displayManager = new MockDisplayManager_1.default();
        const defaultSecretStorage = new DefaultBrowserSecretStorage_1.default(this.window.localStorage, () => this.getDeviceUid());
        this.secretManager = new SubtleCryptoSecretManager_1.default(() => this.window.crypto.subtle, defaultSecretStorage);
        this.powerExecutors = (0, powerExecutors_1.createManagementPowerExecutors)(this, cacheDriver);
    }
    isFrontEnabled() {
        return __awaiter(this, void 0, void 0, function* () {
            return true;
        });
    }
    getAutoRecovery() {
        return __awaiter(this, void 0, void 0, function* () {
            const storedRaw = yield this.asyncStorage.getItem(DefaultManagementDriver.AUTO_RECOVERY_KEY);
            if (storedRaw) {
                return JSON.parse(storedRaw);
            }
            return { enabled: false, autoEnableTimeoutMs: 0 };
        });
    }
    setAutoRecovery(configuration) {
        return __awaiter(this, void 0, void 0, function* () {
            console.log(`Device auto recovery ${configuration.enabled ? `enabled with healthcheck interval ${configuration.healthcheckIntervalMs}ms` : 'disabled'}.`);
            yield this.mergeAsyncStorageItem(DefaultManagementDriver.AUTO_RECOVERY_KEY, configuration);
            if (configuration.enabled === false && configuration.autoEnableTimeoutMs) {
                yield this.internalActionTimers.autoRecovery.set(configuration.autoEnableTimeoutMs);
            }
            else {
                yield this.internalActionTimers.autoRecovery.drop();
            }
        });
    }
    getPeerRecovery() {
        return __awaiter(this, void 0, void 0, function* () {
            const storedRaw = yield this.asyncStorage.getItem(DefaultManagementDriver.PEER_RECOVERY_KEY);
            if (storedRaw) {
                return JSON.parse(storedRaw);
            }
            return { enabled: false, autoEnableTimeoutMs: 0 };
        });
    }
    setPeerRecovery(configuration) {
        return __awaiter(this, void 0, void 0, function* () {
            console.log(`Device peer recovery ${configuration.enabled ? `enabled with URL launcher address ${configuration.urlLauncherAddress}` : 'disabled'}`);
            yield this.mergeAsyncStorageItem(DefaultManagementDriver.PEER_RECOVERY_KEY, configuration);
            if (configuration.enabled === false && configuration.autoEnableTimeoutMs) {
                yield this.internalActionTimers.peerRecovery.set(configuration.autoEnableTimeoutMs);
            }
            else {
                yield this.internalActionTimers.peerRecovery.drop();
            }
        });
    }
    getConfigurationBaseUrl() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.basicDriver.getConfigurationBaseUrl();
        });
    }
    getApplicationType() {
        return this.basicDriver.getApplicationType();
    }
    managementSupports(capability) {
        return __awaiter(this, void 0, void 0, function* () {
            switch (capability) {
                case ManagementCapability_1.default.SCREENSHOT_UPLOAD:
                case ManagementCapability_1.default.MODEL:
                case ManagementCapability_1.default.SERIAL_NUMBER:
                case ManagementCapability_1.default.BRAND:
                case ManagementCapability_1.default.OS_VERSION:
                case ManagementCapability_1.default.TIMERS_PROPRIETARY:
                case ManagementCapability_1.default.TIMERS_NATIVE:
                case ManagementCapability_1.default.STORAGE_UNITS:
                case ManagementCapability_1.default.SYSTEM_REBOOT:
                case ManagementCapability_1.default.APP_RESTART:
                case ManagementCapability_1.default.SET_VOLUME:
                case ManagementCapability_1.default.GET_VOLUME:
                case ManagementCapability_1.default.SET_TIME:
                case ManagementCapability_1.default.GET_TIMEZONE:
                case ManagementCapability_1.default.SET_BRIGHTNESS:
                case ManagementCapability_1.default.GET_BRIGHTNESS:
                case ManagementCapability_1.default.DISPLAY_POWER:
                case ManagementCapability_1.default.APP_UPGRADE:
                case ManagementCapability_1.default.SCREEN_RESIZE:
                case ManagementCapability_1.default.NETWORK_INFO:
                case ManagementCapability_1.default.WIFI:
                case ManagementCapability_1.default.WIFI_SCAN:
                case ManagementCapability_1.default.WIFI_AP:
                case ManagementCapability_1.default.PROXIMITY_SENSOR:
                case ManagementCapability_1.default.FACTORY_RESET:
                case ManagementCapability_1.default.FIRMWARE_UPGRADE:
                case ManagementCapability_1.default.ORIENTATION_LANDSCAPE:
                case ManagementCapability_1.default.ORIENTATION_PORTRAIT:
                case ManagementCapability_1.default.ORIENTATION_LANDSCAPE_FLIPPED:
                case ManagementCapability_1.default.ORIENTATION_PORTRAIT_FLIPPED:
                case ManagementCapability_1.default.SCHEDULE_POWER_ACTION:
                case ManagementCapability_1.default.AUTO_RECOVERY:
                case ManagementCapability_1.default.PEER_RECOVERY:
                case ManagementCapability_1.default.FILE_SYSTEM_WIPEOUT:
                case ManagementCapability_1.default.REMOTE_DESKTOP:
                case ManagementCapability_1.default.EXTENDED_MANAGEMENT:
                case ManagementCapability_1.default.CUSTOM_SCRIPTS:
                case ManagementCapability_1.default.SET_REMOTE_CONTROL_ENABLED:
                case ManagementCapability_1.default.DISPLAY_MANAGER:
                case ManagementCapability_1.default.HARDWARE_ACCELERATION:
                case ManagementCapabilities_1.ManagementCapabilities.SECRETS:
                    return true;
                default:
                    return false;
            }
        });
    }
    initialize(_staticBaseUrl) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, overlayHelper_1.updateOverlay)(this.window, this.asyncStorage);
            yield this.screenRotationManager.applyOrientation();
            this.updateBrightness();
            yield this.realFileSystem.initialize();
            yield this.internalActionTimers.autoRecovery.init();
            yield this.internalActionTimers.peerRecovery.init();
        });
    }
    systemReboot() {
        return __awaiter(this, void 0, void 0, function* () {
            this.window.history.go(0);
        });
    }
    appRestart() {
        this.window.setTimeout(() => this.window.history.go(0), 500);
    }
    appUpgrade(baseUrl, version) {
        return __awaiter(this, void 0, void 0, function* () {
            return () => __awaiter(this, void 0, void 0, function* () {
                this.window.location.href =
                    typeof version !== 'undefined' ? `${baseUrl}/app/default/${version}/index.html${this.window.location.search}` : baseUrl;
            });
        });
    }
    packageInstall(_baseUrl, _packageName, _version, _build) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Not implemented package install');
        });
    }
    start() {
        return this.basicDriver.start();
    }
    stop() {
        return this.basicDriver.stop();
    }
    displayIsPowerOn() {
        return __awaiter(this, void 0, void 0, function* () {
            return !(yield (0, overlayHelper_1.isOverlayShown)(this.asyncStorage));
        });
    }
    displayPowerOn() {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, overlayHelper_1.hideOverlay)(this.window, this.asyncStorage);
        });
    }
    displayPowerOff() {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, overlayHelper_1.showOverlay)(this.window, this.asyncStorage);
        });
    }
    firmwareUpgrade(_baseUrl, _version, _onProgress) {
        return __awaiter(this, void 0, void 0, function* () {
            this.fakeFirmware = yield new MockDeviceFirmwareVersion_1.default().getFirmwareVersion(this.deviceUid, this.getApplicationType());
            const cachedUid = yield this.getCachedFirmwareVersionKey();
            yield this.cache.saveOne(cachedUid, this.fakeFirmware.firmware.uid);
            yield (0, wait_1.default)(2e3);
            return () => this.systemReboot();
        });
    }
    firmwareGetVersion() {
        return __awaiter(this, void 0, void 0, function* () {
            let cachedUid;
            try {
                cachedUid = yield this.getCachedFirmwareVersionKey();
                const fwVersionCached = yield this.cache.fetchOne(cachedUid);
                if (fwVersionCached) {
                    return fwVersionCached;
                }
            }
            catch (e) {
                console.warn(`${cachedUid} is not present in cache yet.`);
            }
            const FIRMWARE_VERSION_REGEX = /(Chrome|Chromium|Firefox)\/([0-9\.]+)/;
            const matches = this.window.navigator.userAgent.match(FIRMWARE_VERSION_REGEX);
            if (matches && matches[2]) {
                return `${matches[1]}-${matches[2]}`;
            }
            else {
                throw new Error(`Unsupported browser for emulator: ${this.window.navigator.userAgent}`);
            }
        });
    }
    firmwareGetType() {
        return __awaiter(this, void 0, void 0, function* () {
            return null;
        });
    }
    getDeviceUid() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.basicDriver.getDeviceUid();
        });
    }
    isConnected() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.basicDriver.isConnected();
        });
    }
    screenResize(_baseUrl, orientation, _resolution, _version, videoOrientation) {
        return __awaiter(this, void 0, void 0, function* () {
            this.settingsManager.setOrientation(orientation, videoOrientation);
            yield (0, wait_1.default)(2e3); // saving value to local storage isn't exactly synchronous so it needs time before application restart
            return () => __awaiter(this, void 0, void 0, function* () { return this.appRestart(); });
        });
    }
    getCurrentOrientation() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.settingsManager.getOrientation();
        });
    }
    setOrientation(_baseUrl, orientation, videoOrientation) {
        return __awaiter(this, void 0, void 0, function* () {
            this.settingsManager.setOrientation(orientation, videoOrientation);
            yield (0, wait_1.default)(2e3); // saving value to local storage isn't exactly synchronous so it needs time before application restart
            return () => __awaiter(this, void 0, void 0, function* () { return this.appRestart(); });
        });
    }
    setResolution(resolution) {
        return __awaiter(this, void 0, void 0, function* () {
            this.settingsManager.setResolution(resolution);
            yield (0, wait_1.default)(2e3); // saving value to local storage isn't exactly synchronous so it needs time before application restart
            return () => __awaiter(this, void 0, void 0, function* () { return this.appRestart(); });
        });
    }
    getResolution() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.settingsManager.getResolution();
        });
    }
    screenSetBrightness(_timeFrom1, brightness1, _timeFrom2, _brightness2) {
        return __awaiter(this, void 0, void 0, function* () {
            this.window.localStorage.setItem(DefaultManagementDriver.BRIGHTNESS_KEY, brightness1.toString());
            this.updateBrightness();
        });
    }
    screenGetBrightness() {
        return __awaiter(this, void 0, void 0, function* () {
            const brightnessValue = this.window.localStorage.getItem(DefaultManagementDriver.BRIGHTNESS_KEY);
            const brightness = brightnessValue !== null ? parseInt(brightnessValue) : 100;
            return {
                timeFrom1: '00:00',
                brightness1: brightness,
                timeFrom2: '00:00',
                brightness2: brightness,
            };
        });
    }
    getSessionId(sessionIdKey) {
        return __awaiter(this, void 0, void 0, function* () {
            const duid = this.deviceUid;
            const sessionRaw = js_cookie_1.default.get(sessionIdKey);
            try {
                const sessionIdMap = sessionRaw ? JSON.parse(sessionRaw) : {};
                return sessionIdMap[duid];
            }
            catch (e) {
                return undefined;
            }
        });
    }
    setSessionId(sessionIdKey, sessionId) {
        return __awaiter(this, void 0, void 0, function* () {
            const duid = this.deviceUid;
            const sessionRaw = js_cookie_1.default.get(sessionIdKey);
            let sessionIdMap;
            try {
                sessionIdMap = sessionRaw ? JSON.parse(sessionRaw) : {};
            }
            catch (e) {
                sessionIdMap = {};
            }
            sessionIdMap[duid] = sessionId;
            js_cookie_1.default.set(sessionIdKey, sessionIdMap, {
                expires: 10 * 365,
            });
        });
    }
    getCurrentTemperature() {
        return __awaiter(this, void 0, void 0, function* () {
            console.info(new Error('Not implemented get current temperature'));
            return 0;
        });
    }
    getTimers() {
        return __awaiter(this, void 0, void 0, function* () {
            const timersJson = this.window.localStorage.getItem(DefaultManagementDriver.TIMERS_KEY);
            if (!timersJson) {
                return [];
            }
            const timers = JSON.parse(timersJson);
            return lodash_1.default.values(timers).map((timer) => ({
                type: TimerType_1.default[timer.type],
                timeOn: timer.timeOn,
                timeOff: timer.timeOff,
                weekdays: convertWeekday_1.convertWeekday.fromShort(timer.weekdays).toTimerWeekday(),
                volume: timer.volume,
            }));
        });
    }
    setTimer(type, timeOn, timeOff, weekdays, volume) {
        return __awaiter(this, void 0, void 0, function* () {
            const timerKey = (0, TimerType_1.numberToNativeTimerType)(type);
            const timersJson = this.window.localStorage.getItem(DefaultManagementDriver.TIMERS_KEY);
            const timers = timersJson ? JSON.parse(timersJson) : {};
            if (timeOn || timeOff) {
                timers[timerKey] = {
                    type: timerKey,
                    timeOn,
                    timeOff,
                    weekdays: convertWeekday_1.convertWeekday.fromTimerWeekday(weekdays).toShort(),
                    volume,
                };
            }
            else {
                delete timers[timerKey];
            }
            this.window.localStorage.setItem(DefaultManagementDriver.TIMERS_KEY, JSON.stringify(timers));
        });
    }
    timerSetOnOffTimeHoliday(_type, _onAtHoliday, _offAtHoliday) {
        console.info('Not implemented set on/off time holiday');
        return Promise.resolve();
    }
    remoteControlSetEnabled(enabled) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.window.localStorage.setItem(DefaultManagementDriver.REMOTE_CONTROL_ENABLED_KEY, enabled ? '1' : '0');
        });
    }
    remoteControlIsEnabled() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.window.localStorage.getItem(DefaultManagementDriver.REMOTE_CONTROL_ENABLED_KEY) === '1' ? true : false;
        });
    }
    screenshotUpload(uploadBaseUrl) {
        var _a, _b, _c;
        return __awaiter(this, void 0, void 0, function* () {
            const uploadUri = uploadBaseUrl + '/upload/file?prefix=screenshot/';
            const screenElement = (_c = (_b = (_a = self.window.document.getElementsByTagName('iframe')[0]) === null || _a === void 0 ? void 0 : _a.contentWindow) === null || _b === void 0 ? void 0 : _b.document.body) !== null && _c !== void 0 ? _c : self.window.document.body;
            const resolution = this.settingsManager.getResolution();
            const screenshotCanvas = yield (0, html2canvas_1.default)(screenElement, {
                width: resolution.width,
                height: resolution.height,
            });
            const screenshotBlob = yield new Promise((resolve) => screenshotCanvas.toBlob((blob) => resolve(blob)));
            const formData = new FormData();
            formData.append('file', screenshotBlob);
            const response = yield self.window.fetch(uploadUri, { method: 'POST', body: formData });
            if (!response.ok) {
                throw new Error('Error during upload screenshot request');
            }
            const data = yield response.json();
            return {
                url: data.uri,
            };
        });
    }
    setDebug(_enabled) {
        return __awaiter(this, void 0, void 0, function* () {
            console.warn(new Error('Not implemented setDebug'));
        });
    }
    isDebugEnabled() {
        return __awaiter(this, void 0, void 0, function* () {
            return false;
        });
    }
    getVolume() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.settingsManager.getVolume();
        });
    }
    setVolume(volume) {
        return __awaiter(this, void 0, void 0, function* () {
            this.settingsManager.setVolume(volume);
        });
    }
    batteryGetStatus() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.window.navigator.getBattery) {
                const battery = yield this.window.navigator.getBattery();
                return {
                    percentage: battery.level * 100,
                    chargeType: battery.charging ? 'AC' : 'NONE',
                    isCharging: battery.charging,
                    lastChargingTime: undefined, // TODO
                };
            }
            return (0, batteryHelper_1.getNoBatteryStatus)();
        });
    }
    resetSettings() {
        return Promise.resolve(); // do nothing
    }
    factoryReset() {
        return __awaiter(this, void 0, void 0, function* () {
            // clear local storage
            this.storage.clear();
            // delete all files from persistent file storage
            const storageUnits = yield this.fileSystem.listStorageUnits();
            for (let storageUnit of storageUnits) {
                const filesInRoot = yield this.fileSystem.listFiles({ storageUnit, filePath: '' });
                for (let file of filesInRoot) {
                    yield this.fileSystem.deleteFile(file, true);
                }
            }
            yield (0, wait_1.default)(1e3); // make sure that local storage clear takes effect
            this.appRestart();
        });
    }
    getSupportedResolutions() {
        return __awaiter(this, void 0, void 0, function* () {
            return ResolutionList_1.ONLY_FULL_HD_RESOLUTION_LIST;
        });
    }
    getExtendedManagementUrl() {
        return __awaiter(this, void 0, void 0, function* () {
            const value = this.window.localStorage.getItem(DefaultManagementDriver.EXTENDED_MANAGEMENT_URL_KEY);
            try {
                return new URL(value).toString();
            }
            catch (e) {
                return null;
            }
        });
    }
    setExtendedManagementUrl(urlInput) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const value = new URL(urlInput).toString();
                this.window.localStorage.setItem(DefaultManagementDriver.EXTENDED_MANAGEMENT_URL_KEY, value);
            }
            catch (_a) {
                /* empty */
            }
        });
    }
    setHardwareAcceleration(enabled) {
        return __awaiter(this, void 0, void 0, function* () {
            this.window.localStorage.setItem(DefaultManagementDriver.HARDWARE_ACCELERATION_KEY, enabled ? '1' : '0');
        });
    }
    isHardwareAccelerationEnabled() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.window.localStorage.getItem(DefaultManagementDriver.HARDWARE_ACCELERATION_KEY) === '1';
        });
    }
    updateBrightness() {
        const brightness = this.window.localStorage.getItem(DefaultManagementDriver.BRIGHTNESS_KEY);
        if (brightness !== null) {
            const newFilter = `brightness(${50 + parseInt(brightness) / 2}%)`;
            this.window.document.body.style.filter = newFilter;
            this.window.document.body.style.webkitFilter = newFilter;
        }
    }
    getCachedFirmwareVersionKey() {
        return __awaiter(this, void 0, void 0, function* () {
            return `LAST_UPGRADED_FIRMWARE;${yield this.getDeviceUid()}`;
        });
    }
    mergeAsyncStorageItem(key, newContent) {
        return __awaiter(this, void 0, void 0, function* () {
            const originalRawContent = yield this.asyncStorage.getItem(key);
            const originalContent = originalRawContent ? JSON.parse(originalRawContent) : {};
            yield this.asyncStorage.setItem(key, JSON.stringify(Object.assign(Object.assign({}, originalContent), newContent)));
        });
    }
}
exports.DefaultManagementDriver = DefaultManagementDriver;
DefaultManagementDriver.BRIGHTNESS_KEY = 'default.native_device.BRIGHTNESS';
DefaultManagementDriver.TIMERS_KEY = 'default.native_device.TIMERS';
DefaultManagementDriver.AUTO_RECOVERY_KEY = 'default.native_device.AUTO_RECOVERY';
DefaultManagementDriver.AUTO_RECOVERY_DEFAULT_HEALTHCHECK_INTERVAL_MS = 30e3;
DefaultManagementDriver.PEER_RECOVERY_KEY = 'default.native_device.PEER_RECOVERY';
DefaultManagementDriver.EXTENDED_MANAGEMENT_URL_KEY = 'default.native_device.EXTENDED_MANAGEMENT_URL';
DefaultManagementDriver.REMOTE_CONTROL_ENABLED_KEY = 'default.native_device.REMOTE_CONTROL_ENABLED';
DefaultManagementDriver.HARDWARE_ACCELERATION_KEY = 'default.native_device.HARDWARE_ACCELERATION';
//# sourceMappingURL=DefaultManagementDriver.js.map