import Orientation from '@signageos/common-types/dist/Device/Resolution/Orientation';
import VideoOrientation from '@signageos/common-types/dist/Device/Resolution/VideoOrientation';
import { NativeTimerType } from '@signageos/common-types/dist/Device/Timer/NativeTimerType';
import TimerWeekday from '@signageos/lib/dist/Timer/Power/PowerTimerWeekday';
import IServletRunner from '../../Servlet/IServletRunner';
import { IProprietaryTimerStorage } from '../../Timer/ITimerStorage';
import IBatteryStatus from '../Battery/IBatteryStatus';
import { IScripts } from '../CustomScripts/IScripts';
import IWifi from '../Hardware/IWifi';
import { IAutoRecoveryConfiguration, IAutoRecoverySettings } from '../IAutoRecovery';
import IBasicDriver from '../IBasicDriver';
import ICacheDriver from '../ICacheDriver';
import IFileSystem from '../IFileSystem';
import IMonitors from '../IMonitors';
import { IPeerRecoveryConfiguration, IPeerRecoverySettings } from '../IPeerRecovery';
import ISystemInfo from '../ISystemInfo';
import { IInput } from '../Input/IInput';
import IManagementDriver, { INativeCommands, IPlatformSpecificAPIs, ISensors } from '../Management/IManagementDriver';
import ManagementCapability from '../Management/ManagementCapability';
import INetwork from '../Network/INetwork';
import IProxy from '../Network/IProxy';
import { ResolutionItem } from '../ResolutionList';
import IScreenRotationManager from '../Screen/IScreenRotationManager';
import ITimeManager from '../TimeManager/ITimeManager';
import NativeFromDriverTimer from '../Timer/ITimer';
import NumberTimerType from '../Timer/TimerType';
import { IVpn } from '../VPN/IVpn';
import DefaultSettingsManager from './DefaultSettingsManager';
import IDisplayManager from '../DisplayManager/IDisplayManager';
import { SecretManager } from '../../Management/Secrets/SecretManager';
import { PowerExecutors } from '../../Management/Device/Power/powerExecutors';
export declare class DefaultManagementDriver implements IManagementDriver {
    private window;
    private deviceUid;
    private cacheDriver;
    private basicDriver;
    private realFileSystem;
    private static BRIGHTNESS_KEY;
    private static TIMERS_KEY;
    private static AUTO_RECOVERY_KEY;
    private static AUTO_RECOVERY_DEFAULT_HEALTHCHECK_INTERVAL_MS;
    private static PEER_RECOVERY_KEY;
    private static EXTENDED_MANAGEMENT_URL_KEY;
    private static REMOTE_CONTROL_ENABLED_KEY;
    private static HARDWARE_ACCELERATION_KEY;
    readonly input: IInput;
    readonly proxy: IProxy;
    readonly systemInfo: ISystemInfo;
    readonly sensors: ISensors;
    readonly platformSpecificAPIs: IPlatformSpecificAPIs;
    readonly monitors: IMonitors;
    readonly network: INetwork;
    readonly wifi: IWifi;
    readonly vpn: IVpn;
    readonly fileSystem: IFileSystem;
    readonly servletRunner: IServletRunner;
    readonly timeManager: ITimeManager;
    readonly proprietaryTimerStorage: IProprietaryTimerStorage;
    readonly nativeCommands: INativeCommands;
    readonly scripts: IScripts;
    readonly displayManager: IDisplayManager;
    readonly secretManager: SecretManager;
    readonly powerExecutors: PowerExecutors;
    private storage;
    private asyncStorage;
    private cache;
    private fakeFirmware?;
    private internalActionTimers;
    protected settingsManager: DefaultSettingsManager;
    protected screenRotationManager: IScreenRotationManager;
    constructor(window: Window, deviceUid: string, settingsManager: DefaultSettingsManager, screenRotationManager: IScreenRotationManager, cacheDriver: ICacheDriver, basicDriver: IBasicDriver, realFileSystem: IFileSystem & {
        initialize(): Promise<void>;
    });
    isFrontEnabled(): Promise<boolean>;
    getAutoRecovery(): Promise<IAutoRecoverySettings>;
    setAutoRecovery(configuration: IAutoRecoveryConfiguration): Promise<void>;
    getPeerRecovery(): Promise<IPeerRecoverySettings>;
    setPeerRecovery(configuration: IPeerRecoveryConfiguration): Promise<void>;
    getConfigurationBaseUrl(): Promise<string | null>;
    getApplicationType(): string;
    managementSupports(capability: ManagementCapability): Promise<boolean>;
    initialize(_staticBaseUrl: string): Promise<void>;
    systemReboot(): Promise<void>;
    appRestart(): void;
    appUpgrade(baseUrl: string, version?: string): Promise<() => Promise<void>>;
    packageInstall(_baseUrl: string, _packageName: string, _version: string, _build: string | null): Promise<void>;
    start(): void;
    stop(): void;
    displayIsPowerOn(): Promise<boolean>;
    displayPowerOn(): Promise<void>;
    displayPowerOff(): Promise<void>;
    firmwareUpgrade(_baseUrl: string, _version?: string, _onProgress?: (progress: number) => void): Promise<() => Promise<void>>;
    firmwareGetVersion(): Promise<string>;
    firmwareGetType(): Promise<null>;
    getDeviceUid(): Promise<string>;
    isConnected(): Promise<boolean>;
    screenResize(_baseUrl: string, orientation: Orientation, _resolution: ResolutionItem, _version: string, videoOrientation?: VideoOrientation): Promise<() => Promise<void>>;
    getCurrentOrientation(): Promise<Orientation.PORTRAIT | Orientation.LANDSCAPE | Orientation.PORTRAIT_FLIPPED | Orientation.LANDSCAPE_FLIPPED>;
    setOrientation(_baseUrl: string, orientation: Orientation, videoOrientation?: VideoOrientation): Promise<() => Promise<void>>;
    setResolution(resolution: ResolutionItem): Promise<() => Promise<void>>;
    getResolution(): Promise<ResolutionItem>;
    screenSetBrightness(_timeFrom1: string, brightness1: number, _timeFrom2: string, _brightness2: number): Promise<void>;
    screenGetBrightness(): Promise<{
        timeFrom1: string;
        brightness1: number;
        timeFrom2: string;
        brightness2: number;
    }>;
    getSessionId(sessionIdKey: string): Promise<any>;
    setSessionId(sessionIdKey: string, sessionId: string): Promise<void>;
    getCurrentTemperature(): Promise<number>;
    getTimers(): Promise<NativeFromDriverTimer[]>;
    setTimer(type: NumberTimerType, timeOn: string | null, timeOff: string | null, weekdays: TimerWeekday[], volume: number): Promise<void>;
    timerSetOnOffTimeHoliday(_type: NativeTimerType, _onAtHoliday: boolean, _offAtHoliday: boolean): Promise<void>;
    remoteControlSetEnabled(enabled: boolean): Promise<void>;
    remoteControlIsEnabled(): Promise<boolean>;
    screenshotUpload(uploadBaseUrl: string): Promise<{
        url: any;
    }>;
    setDebug(_enabled: boolean): Promise<void>;
    isDebugEnabled(): Promise<boolean>;
    getVolume(): Promise<number>;
    setVolume(volume: number): Promise<void>;
    batteryGetStatus(): Promise<IBatteryStatus>;
    resetSettings(): Promise<void>;
    factoryReset(): Promise<void>;
    getSupportedResolutions(): Promise<import("../ResolutionList").default>;
    getExtendedManagementUrl(): Promise<string | null>;
    setExtendedManagementUrl(urlInput: string | null): Promise<void>;
    setHardwareAcceleration(enabled: boolean): Promise<void>;
    isHardwareAccelerationEnabled(): Promise<boolean>;
    private updateBrightness;
    private getCachedFirmwareVersionKey;
    private mergeAsyncStorageItem;
}
