import ISecurity from '../../Front/Security/ISecurity';
import IStreamPlayer from '../../Stream/IStreamPlayer';
import { IProprietaryTimerStorage } from '../../Timer/ITimerStorage';
import IVideoPlayer from '../../Video/IVideoPlayer';
import FrontCapability from '../Front/FrontCapability';
import IFrontDriver, { Hardware } from '../Front/IFrontDriver';
import ITouchEventMessage from '../Front/ITouchEventMessage';
import IBasicDriver from '../IBasicDriver';
import IBrowser from '../IBrowser';
import ICacheDriver from '../ICacheDriver';
import IFileSystem from '../IFileSystem';
import ISignature from '../ISignature';
import IKeyUpEvent from '../Input/IKeyUpEvent';
export declare class DefaultFrontDriver implements IFrontDriver {
    private window;
    readonly video: IVideoPlayer;
    readonly stream: IStreamPlayer;
    readonly browser: IBrowser;
    private basicDriver;
    private storage;
    private realFileSystem;
    private static BRIGHTNESS_KEY;
    readonly hardware: Hardware;
    readonly fileSystem: IFileSystem;
    readonly security: ISecurity;
    readonly proprietaryTimerStorage: IProprietaryTimerStorage;
    private asyncStorage;
    static support(_window: Window): Promise<boolean>;
    constructor(window: Window, video: IVideoPlayer, stream: IStreamPlayer, browser: IBrowser, basicDriver: IBasicDriver, cacheDriver: ICacheDriver, storage: Storage, realFileSystem: IFileSystem & {
        initialize(): Promise<void>;
    });
    getConfigurationBaseUrl(): Promise<string | null>;
    getApplicationType(): string;
    frontSupports(capability: FrontCapability): Promise<boolean>;
    initialize(_staticBaseUrl: string): Promise<void>;
    isDetected(): boolean;
    start(): void;
    stop(): void;
    bindKeyUp(keyUpListener: (keyUpEvent: IKeyUpEvent) => void): void;
    getDeviceUid(): Promise<string>;
    isConnected(): Promise<boolean>;
    getSessionId(sessionIdKey: string): Promise<string | null>;
    setSessionId(sessionIdKey: string, sessionId: string): Promise<void>;
    remoteControlSetEnabled(_enabled: boolean): Promise<void>;
    restoreDisplayArea(): Promise<void>;
    remoteControlIsEnabled(): Promise<boolean>;
    controlSetPin(_pin: string): Promise<void>;
    browserOpenLink(uri: string): Promise<void>;
    getCurrentSignature(): Promise<ISignature | null>;
    getOSDUri(): string;
    forwardTouchEvents(_callback: (data: ITouchEventMessage) => void): Promise<undefined>;
    private updateBrightness;
}
