"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultBasicDriver = void 0;
const js_cookie_1 = __importDefault(require("js-cookie"));
const url_1 = __importDefault(require("url"));
class DefaultBasicDriver {
    static support(_window) {
        return __awaiter(this, void 0, void 0, function* () {
            return true;
        });
    }
    constructor(window, deviceUid) {
        this.window = window;
        this.deviceUid = deviceUid;
    }
    getConfigurationBaseUrl() {
        return __awaiter(this, void 0, void 0, function* () {
            const currentLocation = url_1.default.parse(this.window.location.href, true);
            return currentLocation.query.platformBaseUrl ? currentLocation.query.platformBaseUrl : null;
        });
    }
    getApplicationType() {
        return 'default';
    }
    start() {
        // do nothing
    }
    stop() {
        // do nothing
    }
    getDeviceUid() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.deviceUid;
        });
    }
    isConnected() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.window.navigator.onLine;
        });
    }
    getSessionId(sessionIdKey) {
        return __awaiter(this, void 0, void 0, function* () {
            const duid = this.deviceUid;
            const sessionRaw = js_cookie_1.default.get(sessionIdKey);
            try {
                const sessionIdMap = sessionRaw ? JSON.parse(sessionRaw) : {};
                return sessionIdMap[duid];
            }
            catch (e) {
                return undefined;
            }
        });
    }
    setSessionId(sessionIdKey, sessionId) {
        return __awaiter(this, void 0, void 0, function* () {
            const duid = this.deviceUid;
            const sessionRaw = js_cookie_1.default.get(sessionIdKey);
            let sessionIdMap;
            try {
                sessionIdMap = sessionRaw ? JSON.parse(sessionRaw) : {};
            }
            catch (e) {
                sessionIdMap = {};
            }
            sessionIdMap[duid] = sessionId;
            js_cookie_1.default.set(sessionIdKey, sessionIdMap, {
                expires: 10 * 365,
            });
        });
    }
}
exports.DefaultBasicDriver = DefaultBasicDriver;
//# sourceMappingURL=DefaultBasicDriver.js.map