"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const lockedDecorator_1 = require("@signageos/lib/es6/Lock/lockedDecorator");
class ActionTimer {
    constructor(storage, key, callback) {
        this.storage = storage;
        this.key = key;
        this.timer = { callback };
    }
    init() {
        return __awaiter(this, void 0, void 0, function* () {
            const rawConfiguration = yield this.storage.getItem(this.getStorageKey());
            if (rawConfiguration) {
                const { executeAt } = this.parseConfiguration(rawConfiguration);
                if (executeAt - Date.now() > ActionTimer.MINIMAL_REACTION_PERIOD_MS) {
                    this.start(executeAt - Date.now());
                }
            }
        });
    }
    set(timeout) {
        return __awaiter(this, void 0, void 0, function* () {
            this.stop();
            yield this.storage.setItem(this.getStorageKey(), this.stringifyConfiguration(timeout));
            this.start(timeout);
        });
    }
    drop() {
        return __awaiter(this, void 0, void 0, function* () {
            this.stop();
            yield this.storage.removeItem(this.getStorageKey());
        });
    }
    start(timeout) {
        this.timer.timeoutPointer = setTimeout(() => {
            var _a;
            this.drop();
            (_a = this.timer) === null || _a === void 0 ? void 0 : _a.callback();
        }, timeout);
    }
    stop() {
        if (this.timer.timeoutPointer) {
            clearTimeout(this.timer.timeoutPointer);
        }
    }
    getStorageKey() {
        return `default.native_device.ACTION_TIMERS.${this.key}`;
    }
    stringifyConfiguration(timeout) {
        return JSON.stringify({ executeAt: Date.now() + timeout });
    }
    parseConfiguration(rawConfiguration) {
        return JSON.parse(rawConfiguration);
    }
}
ActionTimer.MINIMAL_REACTION_PERIOD_MS = 1e3;
exports.default = ActionTimer;
__decorate([
    (0, lockedDecorator_1.locked)('actionTimer', { scope: 'instance' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ActionTimer.prototype, "init", null);
__decorate([
    (0, lockedDecorator_1.locked)('actionTimer', { scope: 'instance' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], ActionTimer.prototype, "set", null);
__decorate([
    (0, lockedDecorator_1.locked)('actionTimer', { scope: 'instance' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ActionTimer.prototype, "drop", null);
//# sourceMappingURL=ActionTimer.js.map