"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InMemoryCacheDriver = void 0;
class InMemoryCacheDriver {
    constructor() {
        this.map = new Map();
    }
    cacheGetUids() {
        return __awaiter(this, void 0, void 0, function* () {
            return [...this.map.keys()];
        });
    }
    cacheGetAll() {
        return __awaiter(this, void 0, void 0, function* () {
            return [...this.map.entries()].reduce((acc, [uid, value]) => {
                acc[uid] = value;
                return acc;
            }, {});
        });
    }
    cacheGet(uid) {
        return __awaiter(this, void 0, void 0, function* () {
            const value = this.map.get(uid);
            if (!value) {
                throw new Error(`Cache value for uid ${uid} not found`);
            }
            return value;
        });
    }
    cacheDelete(uid) {
        return __awaiter(this, void 0, void 0, function* () {
            this.map.delete(uid);
        });
    }
    cacheSave(uid, content) {
        return __awaiter(this, void 0, void 0, function* () {
            this.map.set(uid, content);
        });
    }
    cacheGetStorageInfo() {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Not implemented');
        });
    }
}
exports.InMemoryCacheDriver = InMemoryCacheDriver;
//# sourceMappingURL=InMemoryCacheDriver.js.map