"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.managementSaga = void 0;
const effects_1 = require("redux-saga/effects");
const startApplicationSaga_1 = __importDefault(require("../Application/startApplicationSaga"));
const authenticationSagas_1 = require("../Authentication/authenticationSagas");
const dependenciesSaga_1 = require("../DI/dependenciesSaga");
const debugSagas_1 = require("../Debug/debugSagas");
const deviceConfigurationSagas_1 = require("../Device/Configuration/deviceConfigurationSagas");
const deviceAliveSaga_1 = require("../Device/Status/deviceAliveSaga");
const deviceVerificationSagas_1 = require("../Device/Verification/deviceVerificationSagas");
const deviceSagas_1 = require("../Device/deviceSagas");
const timerControllerSagas_1 = require("../Front/Device/Timer/timerControllerSagas");
const deviceSchedulePowerActionSagas_1 = require("./Device/Power/deviceSchedulePowerActionSagas");
const offlineActionsSagas_1 = require("../Offline/offlineActionsSagas");
const OfflineCache_1 = __importDefault(require("../OfflineCache/OfflineCache"));
const remoteDesktopSaga_1 = require("../RemoteDesktop/remoteDesktopSaga");
const socketHealthCheckSagas_1 = require("../Socket/socketHealthCheckSagas");
const socketSagas_1 = require("../Socket/socketSagas");
const commonSystemLogsSagas_1 = require("../SystemLogs/commonSystemLogsSagas");
const testSagas_1 = require("../Test/testSagas");
const pingSagas_1 = require("./Application/pingSagas");
const deviceApplicationSagas_1 = require("./Device/Application/deviceApplicationSagas");
const deviceVolumeSagas_1 = require("./Device/Audio/deviceVolumeSagas");
const autoRecoverySagas_1 = require("./Device/AutoRecovery/autoRecoverySagas");
const deviceBatterySaga_1 = require("./Device/Battery/deviceBatterySaga");
const brightnessControllerSagas_1 = require("./Device/Brightness/brightnessControllerSagas");
const deviceBrightnessSagas_1 = require("./Device/Brightness/deviceBrightnessSagas");
const currentTimeSyncSagas_1 = require("./Device/DateTime/currentTimeSyncSagas");
const deviceDebugSettingsSagas_1 = require("./Device/Debug/deviceDebugSettingsSagas");
const deviceDeprovisionSagas_1 = require("./Device/Deprovision/deviceDeprovisionSagas");
const deviceFirmwareSagas_1 = require("./Device/Firmware/deviceFirmwareSagas");
const devicePackageSagas_1 = require("./Device/Package/devicePackageSagas");
const peerRecoverySaga_1 = require("./Device/PeerRecovery/peerRecoverySaga");
const devicePolicySaga_1 = require("./Device/Policy/devicePolicySaga");
const devicePolicySagas_1 = require("./Device/Policy/devicePolicySagas");
const devicePowerActionSagas_1 = require("./Device/Power/devicePowerActionSagas");
const deviceRemoteControlSagas_1 = require("./Device/RemoteControl/deviceRemoteControlSagas");
const deviceScreenResizeSagas_1 = require("./Device/Screen/deviceScreenResizeSagas");
const deviceStorageSaga_1 = require("./Device/Storage/deviceStorageSaga");
const deviceTelemetryHelper_1 = require("./Device/Telemetry/deviceTelemetryHelper");
const deviceTelemetrySaga_1 = require("./Device/Telemetry/deviceTelemetrySaga");
const deviceTemperatureSaga_1 = require("./Device/Temperature/deviceTemperatureSaga");
const deviceTimerSettingsSagas_1 = require("./Device/Timer/deviceTimerSettingsSagas");
const deviceSagas_2 = require("./Device/deviceSagas");
const extendedManagementSagas_1 = require("./Extended/extendedManagementSagas");
const screenshotSaga_1 = require("./Screen/screenshotSaga");
const servletSagas_1 = require("./Servlet/servletSagas");
const systemLogsSagas_1 = require("./SystemLogs/systemLogsSagas");
const AudioTest_1 = __importDefault(require("./Tests/AudioTest"));
const BatteryTest_1 = __importDefault(require("./Tests/BatteryTest"));
const DebugTest_1 = __importDefault(require("./Tests/DebugTest"));
const DisplayTest_1 = __importDefault(require("./Tests/DisplayTest"));
const InfoTest_1 = __importDefault(require("./Tests/InfoTest"));
const vpnSaga_1 = require("../VPN/vpnSaga");
const timerResolverFactory_1 = require("../Timer/timerResolverFactory");
const networkSagas_1 = require("../Front/Network/networkSagas");
const customScriptsSaga_1 = require("../CustomScripts/customScriptsSaga");
const combinedDriver_1 = require("../NativeDevice/Default/combinedDriver");
const displayManagerSaga_1 = require("./Device/DisplayManager/displayManagerSaga");
const deviceCryptographicSaga_1 = require("./Device/Secrets/deviceCryptographicSaga");
function* managementSaga(defaultConfig, { nativeDriver, publicKey, sessionIdKey, frontDisplayVersion, autoVerification, applicationVersion, bundledApplet, bundledServlet, responsibilities, managementExtraTests, logOfflineActions = true, pingUrl, }, getState, propertyStorage) {
    const { managementDriver, cacheDriver } = (0, combinedDriver_1.normalizeManagementCacheDriver)(nativeDriver);
    const offlineCache = new OfflineCache_1.default(managementDriver.fileSystem);
    const getNativeDriver = () => nativeDriver;
    const getManagementDriver = () => managementDriver;
    const proprietaryTimerStorage = managementDriver.proprietaryTimerStorage;
    const proprietaryTimerManager = (0, timerResolverFactory_1.createProprietaryTimerManagerForManagement)(responsibilities, proprietaryTimerStorage, () => managementDriver.displayIsPowerOn());
    const { powerActionTimer, powerKernel, powerExecutorFacade } = managementDriver.powerExecutors;
    yield (0, effects_1.all)([
        // create DI container as first
        (0, dependenciesSaga_1.dependencyInjection)({
            applicationVersion,
            managementDriver,
            cacheDriver,
            propertyStorage,
            responsibilities,
            proprietaryTimerStorage,
            bundledApplet,
            powerActionTimer,
            telemetryInitialTimeoutMs: (0, deviceTelemetryHelper_1.calculateInitialTelemetryTimeoutMs)(),
            pingUrl,
        }),
        // shared sagas
        (0, socketSagas_1.socketPlatformCreate)(getManagementDriver, 'management', () => managementDriver.timeManager.getEpochMillis(), defaultConfig, powerKernel), // Must be first saga
        (0, socketHealthCheckSagas_1.healthChecking)(),
        (0, deviceConfigurationSagas_1.updatingConfiguration)(getManagementDriver, getManagementDriver, propertyStorage, defaultConfig, publicKey, 'management'),
        (0, authenticationSagas_1.autoDeviceAuthentication)(sessionIdKey, getManagementDriver),
        (0, authenticationSagas_1.storeDeviceSession)(sessionIdKey, getManagementDriver),
        (0, authenticationSagas_1.fallbackDeviceUidAuthentication)(getManagementDriver),
        (0, authenticationSagas_1.afterRegistrationDeviceUidAuthentication)(getManagementDriver),
        (0, deviceSagas_1.fallbackDeviceRegistration)(getManagementDriver, autoVerification),
        (0, deviceVerificationSagas_1.deviceVerification)(getManagementDriver),
        // management sagas
        (0, deviceApplicationSagas_1.syncApplicationVersionSaga)(responsibilities),
        (0, brightnessControllerSagas_1.brightnessRefresh)(getManagementDriver, propertyStorage),
        (0, devicePowerActionSagas_1.deviceDisplayPowerAction)(getManagementDriver),
        (0, devicePowerActionSagas_1.devicePerformScheduledPowerAction)(powerExecutorFacade),
        (0, deviceSchedulePowerActionSagas_1.deviceSchedulePowerAction)(getManagementDriver, responsibilities, powerActionTimer),
        (0, timerControllerSagas_1.displayTimerChecking)(responsibilities, proprietaryTimerManager),
        (0, currentTimeSyncSagas_1.startupDeviceDateTimeSettings)(),
        (0, deviceSagas_2.notifyDeviceSaga)(getManagementDriver, responsibilities),
        (0, deviceSagas_1.notifyDeviceFrontDisplayVersion)(frontDisplayVersion),
        (0, deviceSagas_2.notifyDeviceApplicationVersion)(getManagementDriver, responsibilities, applicationVersion),
        (0, pingSagas_1.pinging)(),
        (0, deviceFirmwareSagas_1.deviceFirmwareNotify)(responsibilities, () => managementDriver.getDeviceUid()),
        (0, deviceFirmwareSagas_1.deviceFirmwareUpgrade)(responsibilities, () => managementDriver.getDeviceUid()),
        (0, deviceVolumeSagas_1.deviceVolumeSaga)(getManagementDriver, responsibilities),
        (0, deviceBrightnessSagas_1.syncBrightnessSettingsSaga)(getManagementDriver, responsibilities, propertyStorage),
        (0, devicePackageSagas_1.installPackageSaga)(responsibilities),
        (0, deviceDeprovisionSagas_1.deviceDeprovision)(getNativeDriver, responsibilities, sessionIdKey),
        (0, devicePowerActionSagas_1.devicePerformPowerAction)(getManagementDriver, responsibilities, powerExecutorFacade),
        (0, deviceTimerSettingsSagas_1.syncDeviceTimerSettingsSaga)(getManagementDriver, responsibilities, proprietaryTimerStorage),
        (0, deviceScreenResizeSagas_1.resizeScreen)(responsibilities),
        (0, deviceScreenResizeSagas_1.reportScreen)(responsibilities),
        (0, deviceRemoteControlSagas_1.syncRemoteControlSettingsSaga)(getManagementDriver, responsibilities),
        (0, extendedManagementSagas_1.deviceExtendedManagementSaga)(getManagementDriver, responsibilities),
        (0, currentTimeSyncSagas_1.updateTimeSettingsSaga)(),
        (0, deviceDebugSettingsSagas_1.devicePerformDebugSettings)(getManagementDriver, responsibilities),
        (0, deviceBatterySaga_1.deviceBatterySaga)()(),
        (0, deviceStorageSaga_1.createDeviceStorageSaga)()(),
        (0, deviceTemperatureSaga_1.deviceTemperatureSaga)(responsibilities),
        (0, screenshotSaga_1.periodicScreenshotSaga)(responsibilities),
        (0, screenshotSaga_1.instantScreenshotSaga)(responsibilities),
        (0, testSagas_1.runTestsSaga)([
            (0, AudioTest_1.default)(managementDriver),
            (0, BatteryTest_1.default)(managementDriver),
            (0, DebugTest_1.default)(managementDriver),
            (0, DisplayTest_1.default)(managementDriver, responsibilities),
            (0, InfoTest_1.default)(managementDriver),
            ...(managementExtraTests !== null && managementExtraTests !== void 0 ? managementExtraTests : []),
        ]),
        (0, servletSagas_1.subscribeActiveServlets)(getState, responsibilities, getManagementDriver),
        (0, commonSystemLogsSagas_1.commonSystemLogsSaga)(),
        (0, systemLogsSagas_1.systemLogsSaga)(),
        ...(logOfflineActions ? [(0, offlineActionsSagas_1.offlineActionsSaga)('management.', getManagementDriver, getManagementDriver)] : []),
        (0, servletSagas_1.runServlets)(responsibilities, offlineCache),
        (0, servletSagas_1.runBundledServlet)(responsibilities, bundledServlet),
        (0, deviceTelemetrySaga_1.deviceTelemetrySaga)(responsibilities, getManagementDriver, propertyStorage, proprietaryTimerStorage, applicationVersion, powerActionTimer)(),
        (0, devicePolicySaga_1.devicePolicySaga)(),
        (0, devicePolicySagas_1.subscribeDevicePolicy)(responsibilities, getState),
        (0, devicePolicySagas_1.updateDevicePolicy)(responsibilities, propertyStorage),
        (0, remoteDesktopSaga_1.remoteDesktopSaga)(),
        (0, debugSagas_1.debugAllActions)(),
        (0, startApplicationSaga_1.default)(),
        (0, deviceAliveSaga_1.notifyDeviceStatus)(),
        (0, autoRecoverySagas_1.autoRecoverySaga)(getManagementDriver, responsibilities),
        (0, peerRecoverySaga_1.peerRecoverySaga)(getManagementDriver, responsibilities),
        (0, vpnSaga_1.vpnSaga)(getManagementDriver, responsibilities),
        (0, networkSagas_1.checkingStatusChange)(getManagementDriver),
        (0, customScriptsSaga_1.customScriptsSaga)(offlineCache),
        (0, displayManagerSaga_1.displayManagerSaga)(),
        (0, deviceCryptographicSaga_1.cryptographySaga)(getManagementDriver, responsibilities),
    ]);
}
exports.managementSaga = managementSaga;
//# sourceMappingURL=managementSagas.js.map