"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const t = __importStar(require("./../../Test/TestFramework"));
const should_1 = __importDefault(require("../../Test/should"));
const ManagementCapability_1 = __importDefault(require("../../NativeDevice/Management/ManagementCapability"));
const deviceTestActions_1 = require("@signageos/actions/dist/Device/Test/deviceTestActions");
const momentTimezone = __importStar(require("moment-timezone"));
exports.default = (nativeDriver) => __awaiter(void 0, void 0, void 0, function* () {
    const skipIfDeviceDoesntSupport = (...capabilities) => __awaiter(void 0, void 0, void 0, function* () {
        for (const capability of capabilities) {
            if (!(yield nativeDriver.managementSupports(capability))) {
                t.skip(`The device does not provide "${capability}" capability`);
                break;
            }
        }
    });
    return t.describe(deviceTestActions_1.TestCase.DATE_TIME, function* () {
        yield t.it('Should get datetime and timezone', () => __awaiter(this, void 0, void 0, function* () {
            yield skipIfDeviceDoesntSupport(ManagementCapability_1.default.GET_TIMEZONE);
            const timestampMs = yield nativeDriver.timeManager.getEpochMillis();
            const timezone = yield nativeDriver.timeManager.getZoneId();
            (0, should_1.default)(timestampMs).be.Number();
            (0, should_1.default)(timestampMs).be.greaterThanOrEqual(0);
            (0, should_1.default)(timezone).be.oneOf(momentTimezone.tz.names());
        }));
        yield t.it('Should set time', () => __awaiter(this, void 0, void 0, function* () {
            yield skipIfDeviceDoesntSupport(ManagementCapability_1.default.SET_TIME, ManagementCapability_1.default.GET_TIMEZONE);
            const timestampMs = yield nativeDriver.timeManager.getEpochMillis();
            const timezone = yield nativeDriver.timeManager.getZoneId();
            const diff = 5 * 60 * 1000; // 5 minutes
            yield nativeDriver.timeManager.setManual(timestampMs - diff, timezone);
            const newTimestampMs = yield nativeDriver.timeManager.getEpochMillis();
            const newTimezone = yield nativeDriver.timeManager.getZoneId();
            (0, should_1.default)(newTimezone).equal(timezone);
            (0, should_1.default)(newTimestampMs - timestampMs).be.greaterThanOrEqual(diff);
            yield nativeDriver.timeManager.setManual(timestampMs, timezone);
        }));
        yield t.it('Should change the timezone', () => __awaiter(this, void 0, void 0, function* () {
            yield skipIfDeviceDoesntSupport(ManagementCapability_1.default.SET_TIME, ManagementCapability_1.default.GET_TIMEZONE, ManagementCapability_1.default.SET_TIMEZONE);
            const timestampMs = yield nativeDriver.timeManager.getEpochMillis();
            const timezone = yield nativeDriver.timeManager.getZoneId();
            const timezoneList = momentTimezone.tz.names();
            const diff = 5 * 60 * 1000; // 5 minutes
            yield nativeDriver.timeManager.setManual(timestampMs - diff, timezoneList[(timezoneList.indexOf(timezone) + 10) % timezoneList.length]);
            const newTimestampMs = yield nativeDriver.timeManager.getEpochMillis();
            const newTimezone = yield nativeDriver.timeManager.getZoneId();
            (0, should_1.default)(newTimezone).equal(timezoneList[(timezoneList.indexOf(timezone) + 10) % timezoneList.length]);
            (0, should_1.default)(newTimestampMs - timestampMs).be.greaterThanOrEqual(diff);
            yield nativeDriver.timeManager.setManual(timestampMs, timezone);
        }));
    });
});
//# sourceMappingURL=DateTimeTest.js.map