import { SecretStorage } from './SecretStorage';
import { JweGeneral, RsaPublicKeyData, SecretManager } from './SecretManager';
export default class SubtleCryptoSecretManager implements SecretManager {
    private subtleCrypto;
    private storage;
    constructor(subtleCrypto: () => SubtleCrypto, storage: SecretStorage);
    generateKeys(): Promise<void>;
    encryptUtf8ToJweCompact(text: string): Promise<string>;
    decryptJweCompactToUtf8(jweCompact: string): Promise<string>;
    decryptJweCompactToBytes(jweCompact: string): Promise<Uint8Array>;
    encryptBytesToJweCompact(value: Uint8Array): Promise<string>;
    encryptUtf8ToJweGeneral(text: string): Promise<JweGeneral>;
    decryptJweGeneralToUtf8(jweGeneral: JweGeneral): Promise<string>;
    decryptJweGeneralToBytes(jweGeneral: JweGeneral): Promise<Uint8Array>;
    encryptBytesToJweGeneral(value: Uint8Array): Promise<JweGeneral>;
    getPublicKey(): Promise<RsaPublicKeyData>;
    private saveKeyPair;
    private requirePrivateKey;
    private requirePublicKey;
    private requireKeyPair;
}
