import * as jose from 'jose';
export interface SecretManager {
    decryptJweCompactToUtf8(jweCompact: string): Promise<string>;
    encryptUtf8ToJweCompact(value: string): Promise<string>;
    decryptJweCompactToBytes(jweCompact: string): Promise<Uint8Array>;
    encryptBytesToJweCompact(value: Uint8Array): Promise<string>;
    decryptJweGeneralToUtf8(jweGeneral: JweGeneral): Promise<string>;
    encryptUtf8ToJweGeneral(value: string): Promise<JweGeneral>;
    decryptJweGeneralToBytes(jweGeneral: JweGeneral): Promise<Uint8Array>;
    encryptBytesToJweGeneral(value: Uint8Array): Promise<JweGeneral>;
    generateKeys(): Promise<void>;
    getPublicKey(): Promise<RsaPublicKeyData>;
}
export interface RsaPublicKeyData {
    algorithm?: RsaHashedKeyAlgorithm;
    publicKeySpki: string;
    keyValidity?: {
        start?: Date;
        end?: Date;
    };
}
export type JweGeneral = jose.GeneralJWE;
