import { RsaKeyPairData, SecretStorage } from './SecretStorage';
export default class DefaultBrowserSecretStorage implements SecretStorage {
    private storage;
    private getDeviceUid;
    private static readonly KEY_ALGORITHM;
    private static readonly KEY_HASH;
    private static readonly KEY_LENGTH;
    private static readonly KEY_ITERATIONS;
    private static readonly AES_ALGORITHM;
    private static readonly AES_IV_LENGTH;
    private static readonly SALT_LENGTH;
    constructor(storage: Storage, getDeviceUid: () => Promise<string>);
    saveKeyPair(name: string, keyPair: RsaKeyPairData): Promise<void>;
    getKeyPair(name: string): Promise<RsaKeyPairData | null>;
    private deriveKey;
    private encryptData;
    private decryptData;
    private uint8ToBase64;
    private base64ToUint8;
}
