"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deviceExtendedManagementSaga = exports.setDeviceExtendedManagementCallback = void 0;
const deviceExtendedManagementActions_1 = require("@signageos/actions/dist/Device/ExtendedManagement/deviceExtendedManagementActions");
const effects_1 = require("redux-saga/effects");
const Responsibility_1 = __importDefault(require("../../Feature/Responsibility"));
const ManagementCapability_1 = __importDefault(require("../../NativeDevice/Management/ManagementCapability"));
const socketActionCreator_1 = require("../../Socket/socketActionCreator");
function* setDeviceExtendedManagementCallback(getNativeDriver, action) {
    try {
        const nativeDriver = getNativeDriver();
        yield (0, effects_1.apply)(nativeDriver, nativeDriver.setExtendedManagementUrl, [action.url]);
        yield (0, effects_1.put)({
            type: deviceExtendedManagementActions_1.SetExtendedManagementUrlSucceeded,
            uid: action.uid,
        });
    }
    catch (error) {
        console.error('deviceVolumeSaga', error);
        yield (0, effects_1.put)({
            type: deviceExtendedManagementActions_1.SetExtendedManagementUrlFailed,
            uid: action.uid,
        });
    }
}
exports.setDeviceExtendedManagementCallback = setDeviceExtendedManagementCallback;
function* deviceExtendedManagementSaga(getNativeDriver, responsibilities) {
    if (!responsibilities.has(Responsibility_1.default.EXTENDED_MANAGEMENT)) {
        return;
    }
    yield (0, socketActionCreator_1.bindWhenPlatform)(deviceExtendedManagementActions_1.SetExtendedManagementUrl);
    const supports = yield getNativeDriver().managementSupports(ManagementCapability_1.default.EXTENDED_MANAGEMENT);
    if (supports) {
        yield (0, effects_1.takeEvery)(deviceExtendedManagementActions_1.SetExtendedManagementUrl, setDeviceExtendedManagementCallback, getNativeDriver);
    }
}
exports.deviceExtendedManagementSaga = deviceExtendedManagementSaga;
//# sourceMappingURL=extendedManagementSagas.js.map