"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getProprietaryTimers = exports.getNativeTimers = exports.telemetryDeviceProprietaryTimerSaga = exports.telemetryDeviceTimerSaga = void 0;
const DeviceTelemetryType_1 = require("@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType");
const convertWeekday_1 = require("@signageos/lib/dist/Timer/convertWeekday");
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const deviceTelemetrySagas_1 = require("../Telemetry/deviceTelemetrySagas");
const TimerType_1 = require("../../../NativeDevice/Timer/TimerType");
exports.telemetryDeviceTimerSaga = (0, deviceTelemetrySagas_1.createDeviceTelemetrySaga)(DeviceTelemetryType_1.DeviceTelemetryType.TIMERS, Responsibility_1.default.TIMERS, [ManagementCapability_1.default.TIMERS_NATIVE], getNativeTimers);
exports.telemetryDeviceProprietaryTimerSaga = (0, deviceTelemetrySagas_1.createDeviceTelemetrySaga)(DeviceTelemetryType_1.DeviceTelemetryType.PROPRIETARY_TIMERS, Responsibility_1.default.TIMERS, [ManagementCapability_1.default.TIMERS_PROPRIETARY], getProprietaryTimers);
function getNativeTimers({ managementDriver }) {
    return __awaiter(this, void 0, void 0, function* () {
        const timers = yield managementDriver.getTimers();
        return timers.map((timer) => ({
            type: (0, TimerType_1.numberToNativeTimerType)(timer.type),
            timeOn: typeof timer.timeOn === 'string' ? timer.timeOn.replace(/^(\d{2}):(\d{2}).*/, '$1:$2:00') : null,
            timeOff: typeof timer.timeOff === 'string' ? timer.timeOff.replace(/^(\d{2}):(\d{2}).*/, '$1:$2:00') : null,
            weekdays: convertWeekday_1.convertWeekday.fromTimerWeekday(timer.weekdays).toLong(),
            volume: timer.volume,
        }));
    });
}
exports.getNativeTimers = getNativeTimers;
function getProprietaryTimers({ timerStorage }) {
    return __awaiter(this, void 0, void 0, function* () {
        const timers = yield timerStorage.getShortTimers();
        return Object.values(timers).map((t) => (Object.assign(Object.assign({}, t), { weekdays: convertWeekday_1.convertWeekday.fromShort(t.weekdays).toLong() })));
    });
}
exports.getProprietaryTimers = getProprietaryTimers;
//# sourceMappingURL=deviceTimerTelemetrySagas.js.map