"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.setNativeTimer = exports.syncDeviceTimerSettingsSaga = exports.setDeviceTimerSettingsCallback = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const deviceTimerActions_1 = require("@signageos/actions/dist/Device/Timer/deviceTimerActions");
const convertWeekday_1 = require("@signageos/lib/dist/Timer/convertWeekday");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const deviceProprietaryTimerSagas_1 = require("../../../Device/Timer/deviceProprietaryTimerSagas");
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const TimerLevel_1 = require("@signageos/common-types/dist/Device/Timer/TimerLevel");
const TimerType_1 = __importDefault(require("../../../NativeDevice/Timer/TimerType"));
function* setDeviceTimerSettingsCallback(getNativeDriver, proprietaryTimerStorage, action) {
    const nativeDriver = getNativeDriver();
    const supportsNativeTimers = yield nativeDriver.managementSupports(ManagementCapability_1.default.TIMERS_NATIVE);
    const supportsProprietaryTimers = yield nativeDriver.managementSupports(ManagementCapability_1.default.TIMERS_PROPRIETARY);
    if (supportsNativeTimers && action.level === TimerLevel_1.TimerLevel.Native) {
        try {
            yield (0, effects_1.call)(setNativeTimer, nativeDriver, action);
            yield (0, effects_1.put)({
                type: deviceTimerActions_1.SetDeviceTimerSettingsSucceeded,
                uid: action.uid,
            });
        }
        catch (error) {
            console.error('syncTimerSettingsSaga', error);
            yield (0, effects_1.put)({
                type: deviceTimerActions_1.SetDeviceTimerSettingsFailed,
                uid: action.uid,
            });
        }
    }
    else if (supportsProprietaryTimers) {
        // In addition to handling proprietary timers,
        // If native timers are not supported set proprietary timers instead
        try {
            yield (0, effects_1.call)(deviceProprietaryTimerSagas_1.setProprietaryTimer, proprietaryTimerStorage, action);
            yield (0, effects_1.put)({
                type: deviceTimerActions_1.SetDeviceTimerSettingsSucceeded,
                uid: action.uid,
            });
        }
        catch (error) {
            console.error('syncTimerSettingsSaga', error);
            yield (0, effects_1.put)({
                type: deviceTimerActions_1.SetDeviceTimerSettingsFailed,
                uid: action.uid,
            });
        }
    }
}
exports.setDeviceTimerSettingsCallback = setDeviceTimerSettingsCallback;
function* syncDeviceTimerSettingsSaga(getNativeDriver, responsibilities, proprietaryTimerStorage) {
    if (!responsibilities.has(Responsibility_1.default.TIMERS)) {
        return;
    }
    yield (0, socketActionCreator_1.takeEveryAndBindWhenPlatform)(deviceTimerActions_1.SetDeviceTimerSettings, setDeviceTimerSettingsCallback, getNativeDriver, proprietaryTimerStorage);
}
exports.syncDeviceTimerSettingsSaga = syncDeviceTimerSettingsSaga;
function setNativeTimer(nativeDriver, action) {
    return __awaiter(this, void 0, void 0, function* () {
        yield nativeDriver.setTimer(TimerType_1.default[action.timerType], action.timeOn, action.timeOff, convertWeekday_1.convertWeekday.fromShort(action.weekdays).toTimerWeekday(), action.volume);
    });
}
exports.setNativeTimer = setNativeTimer;
//# sourceMappingURL=deviceTimerSettingsSagas.js.map