"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deviceTemperatureSaga = void 0;
const effects_1 = require("redux-saga/effects");
const deviceTemperatureActions_1 = require("@signageos/actions/dist/Device/Temperature/deviceTemperatureActions");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const capable_1 = require("../../../Feature/capable");
const dependencyInjection_1 = require("../../../DI/dependencyInjection");
const deviceTelemetryHelper_1 = require("../Telemetry/deviceTelemetryHelper");
function* deviceTemperatureSaga(responsibilities) {
    if (!responsibilities.has(Responsibility_1.default.TEMPERATURE)) {
        return;
    }
    yield (0, effects_1.fork)((0, capable_1.whenCapable)(ManagementCapability_1.default.TEMPERATURE, (0, dependencyInjection_1.withDependencies)(['managementDriver', 'telemetryIntervals'], function* ({ managementDriver, telemetryIntervals }) {
        var _a;
        const periodMs = (_a = telemetryIntervals === null || telemetryIntervals === void 0 ? void 0 : telemetryIntervals.temperature) !== null && _a !== void 0 ? _a : 0;
        yield (0, deviceTelemetryHelper_1.registerTelemetry)('TEMPERATURE', periodMs, function* () {
            try {
                const temperature = yield managementDriver.getCurrentTemperature();
                yield (0, effects_1.put)({
                    type: deviceTemperatureActions_1.RecordTemperature,
                    temperature,
                });
            }
            catch (error) {
                console.error('deviceTemperatureSaga', error);
            }
        });
    })));
}
exports.deviceTemperatureSaga = deviceTemperatureSaga;
//# sourceMappingURL=deviceTemperatureSaga.js.map