"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTelemetryPropertyName = exports.getPropertyName = exports.createDeviceTelemetrySaga = void 0;
const deviceAudioActions_1 = require("@signageos/actions/dist/Device/Audio/deviceAudioActions");
const deviceAutoRecoveryActions_1 = require("@signageos/actions/dist/Device/AutoRecovery/deviceAutoRecoveryActions");
const deviceBrightnessActions_1 = require("@signageos/actions/dist/Device/Brightness/deviceBrightnessActions");
const deviceDateTimeActions_1 = require("@signageos/actions/dist/Device/DateTime/deviceDateTimeActions");
const deviceDebugActions_1 = require("@signageos/actions/dist/Device/Debug/deviceDebugActions");
const deviceExtendedManagementActions_1 = require("@signageos/actions/dist/Device/ExtendedManagement/deviceExtendedManagementActions");
const devicePeerRecoveryActions_1 = require("@signageos/actions/dist/Device/PeerRecovery/devicePeerRecoveryActions");
const devicePolicyActions_1 = require("@signageos/actions/dist/Device/Policy/devicePolicyActions");
const devicePowerActions_1 = require("@signageos/actions/dist/Device/Power/devicePowerActions");
const deviceRemoteControlActions_1 = require("@signageos/actions/dist/Device/RemoteControl/deviceRemoteControlActions");
const deviceResolutionActions_1 = require("@signageos/actions/dist/Device/Resolution/deviceResolutionActions");
const deviceTelemetryActions_1 = require("@signageos/actions/dist/Device/Telemetry/deviceTelemetryActions");
const deviceTimerActions_1 = require("@signageos/actions/dist/Device/Timer/deviceTimerActions");
const DeviceSettingsType_1 = require("@signageos/common-types/dist/Device/Settings/DeviceSettingsType");
const DeviceTelemetryType_1 = require("@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType");
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const debug_1 = __importDefault(require("debug"));
const lodash_1 = __importDefault(require("lodash"));
const effects_1 = require("redux-saga/effects");
const telemetryIntervals_1 = require("../../../Device/Configuration/telemetryIntervals");
const dependencyInjection_1 = require("../../../DI/dependencyInjection");
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const Property_1 = __importDefault(require("../../../Property/Property"));
const socketActionDeliverHelper_1 = require("./../../../Socket/socketActionDeliverHelper");
const deviceTelemetryHelper_1 = require("./deviceTelemetryHelper");
const networkActions_1 = require("../../../Front/Network/networkActions");
const deviceCryptographicSaga_1 = require("../Secrets/deviceCryptographicSaga");
const deviceCustomScriptActions_1 = require("@signageos/actions/dist/Device/CustomScript/deviceCustomScriptActions");
const debug = (0, debug_1.default)('@signageos/front-display:Management:Telemetry');
const createDeviceTelemetrySaga = (type, responsibility, requiredCapabilities, getSettings) => (0, dependencyInjection_1.withDependencies)(['telemetryIntervals'], function* ({ telemetryIntervals, }, responsibilities, getManagementDriver, propertyStorage, timerStorage, powerActionRules, applicationVersion) {
    var _a;
    if (!responsibilities.has(Responsibility_1.default.TELEMETRY) || !responsibilities.has(responsibility)) {
        return;
    }
    for (const capability of requiredCapabilities) {
        const supported = yield getManagementDriver().managementSupports(capability);
        if (!supported) {
            return;
        }
    }
    yield (0, effects_1.takeEvery)(devicePolicyActions_1.ApplyPolicySucceeded, function* (actionType) {
        if (actionType.name === type) {
            yield forceTelemetryUpdate(type, getSettings, getManagementDriver, propertyStorage, timerStorage, powerActionRules, applicationVersion);
        }
    });
    yield (0, effects_1.takeEvery)(deviceCustomScriptActions_1.ExecuteCustomScriptSucceeded, function* () {
        yield getSettingsAndSendItWhenChanged(type, getSettings, getManagementDriver, propertyStorage, timerStorage, powerActionRules, applicationVersion);
    });
    const succeedAction = convertTypeToAction(type);
    if (succeedAction) {
        yield (0, effects_1.takeEvery)(succeedAction, function* () {
            yield forceTelemetryUpdate(type, getSettings, getManagementDriver, propertyStorage, timerStorage, powerActionRules, applicationVersion);
        });
        if (type === DeviceTelemetryType_1.DeviceTelemetryType.POWER_ACTIONS_SCHEDULE) {
            yield (0, effects_1.takeEvery)(devicePowerActions_1.CancelScheduledPowerActionSucceed, function* () {
                yield forceTelemetryUpdate(type, getSettings, getManagementDriver, propertyStorage, timerStorage, powerActionRules, applicationVersion);
            });
        }
    }
    const telemetryIntervalType = convertTelemetryTypeToIntervalType(type);
    const periodMs = (_a = telemetryIntervals === null || telemetryIntervals === void 0 ? void 0 : telemetryIntervals[telemetryIntervalType]) !== null && _a !== void 0 ? _a : 0;
    yield (0, deviceTelemetryHelper_1.registerTelemetry)(type, periodMs, function* () {
        try {
            // Browser (localStorage) remembers the last telemetry data
            // When we switch app type (e.g. from CA to CC), there might be old saved telemetry data
            // so we need to force updated them, because the check for change will not pass
            if (type === DeviceTelemetryType_1.DeviceTelemetryType.APP_MODULES) {
                yield* forceTelemetryUpdate(type, getSettings, getManagementDriver, propertyStorage, timerStorage, powerActionRules, applicationVersion);
            }
            yield* getSettingsAndSendItWhenChanged(type, getSettings, getManagementDriver, propertyStorage, timerStorage, powerActionRules, applicationVersion);
        }
        catch (error) {
            debug(`reporting device settings ${type} failed`, error);
        }
    });
});
exports.createDeviceTelemetrySaga = createDeviceTelemetrySaga;
function* getSettingsAndSendItWhenChanged(type, getSettings, getManagementDriver, propertyStorage, timerStorage, powerActionRules, applicationVersion) {
    const property = getTelemetryPropertyName(type, 'LATEST_REPORTED_SETTINGS');
    const cachedDeviceSettings = yield propertyStorage.getValueOrDefault(property, undefined);
    const currentDeviceSettings = yield getSettings({
        managementDriver: getManagementDriver(),
        timerStorage,
        powerActionRules,
        propertyStorage,
        applicationVersion,
    });
    const isDeviceSettingsChanged = !lodash_1.default.isEqual(cachedDeviceSettings, currentDeviceSettings);
    if (isDeviceSettingsChanged) {
        yield (0, socketActionDeliverHelper_1.deliver)({
            type: deviceTelemetryActions_1.UpdateDeviceTelemetryRecord,
            name: type,
            data: currentDeviceSettings,
        });
        yield propertyStorage.setValue(property, currentDeviceSettings);
    }
}
function* forceTelemetryUpdate(type, getSettings, getManagementDriver, propertyStorage, timerStorage, powerActionRules, applicationVersion) {
    const property = getTelemetryPropertyName(type, 'LATEST_REPORTED_SETTINGS');
    // Delay for resolving deviceLog
    yield (0, wait_1.default)(500);
    try {
        const currentDeviceSettings = yield getSettings({
            managementDriver: getManagementDriver(),
            timerStorage,
            powerActionRules,
            propertyStorage,
            applicationVersion,
        });
        yield (0, socketActionDeliverHelper_1.deliver)({
            type: deviceTelemetryActions_1.UpdateDeviceTelemetryRecord,
            name: type,
            data: currentDeviceSettings,
        });
        yield propertyStorage.setValue(property, currentDeviceSettings);
    }
    catch (error) {
        console.error('forceTelemetryUpdate failed', error);
    }
}
function getPropertyName(type, prefix) {
    if (typeof DeviceSettingsType_1.DeviceSettingsType[type] === 'undefined') {
        throw Error(`Device settings type ${type} does not exist`);
    }
    const propertyKey = `${prefix}_${DeviceSettingsType_1.DeviceSettingsType[type]}`;
    if (typeof Property_1.default[propertyKey] === 'undefined') {
        throw Error(`Property key is not valid ${propertyKey}`);
    }
    return Property_1.default[propertyKey];
}
exports.getPropertyName = getPropertyName;
function getTelemetryPropertyName(type, prefix) {
    if (typeof DeviceTelemetryType_1.DeviceTelemetryType[type] === 'undefined') {
        throw Error(`Device settings type ${type} does not exist`);
    }
    const propertyKey = `${prefix}_${DeviceTelemetryType_1.DeviceTelemetryType[type]}`;
    if (typeof Property_1.default[propertyKey] === 'undefined') {
        throw Error(`Property key is not valid ${propertyKey}`);
    }
    return Property_1.default[propertyKey];
}
exports.getTelemetryPropertyName = getTelemetryPropertyName;
function convertTelemetryTypeToIntervalType(type) {
    switch (type) {
        case DeviceTelemetryType_1.DeviceTelemetryType.APPLICATION_VERSION:
            return telemetryIntervals_1.IntervalType.APPLICATION_VERSION;
        case DeviceTelemetryType_1.DeviceTelemetryType.BRIGHTNESS:
            return telemetryIntervals_1.IntervalType.BRIGHTNESS;
        case DeviceTelemetryType_1.DeviceTelemetryType.DATETIME:
            return telemetryIntervals_1.IntervalType.DATETIME;
        case DeviceTelemetryType_1.DeviceTelemetryType.DEBUG:
            return telemetryIntervals_1.IntervalType.DEBUG;
        case DeviceTelemetryType_1.DeviceTelemetryType.FIRMWARE_VERSION:
            return telemetryIntervals_1.IntervalType.FIRMWARE_VERSION;
        case DeviceTelemetryType_1.DeviceTelemetryType.ORIENTATION:
            return telemetryIntervals_1.IntervalType.ORIENTATION;
        case DeviceTelemetryType_1.DeviceTelemetryType.POWER_ACTIONS_SCHEDULE:
            return telemetryIntervals_1.IntervalType.POWER_ACTIONS_SCHEDULE;
        case DeviceTelemetryType_1.DeviceTelemetryType.PROPRIETARY_TIMERS:
            return telemetryIntervals_1.IntervalType.PROPRIETARY_TIMERS;
        case DeviceTelemetryType_1.DeviceTelemetryType.REMOTE_CONTROL:
            return telemetryIntervals_1.IntervalType.REMOTE_CONTROL;
        case DeviceTelemetryType_1.DeviceTelemetryType.RESOLUTION:
            return telemetryIntervals_1.IntervalType.RESOLUTION;
        case DeviceTelemetryType_1.DeviceTelemetryType.TEMPERATURE:
            return telemetryIntervals_1.IntervalType.TEMPERATURE;
        case DeviceTelemetryType_1.DeviceTelemetryType.TIMERS:
            return telemetryIntervals_1.IntervalType.TIMERS;
        case DeviceTelemetryType_1.DeviceTelemetryType.VOLUME:
            return telemetryIntervals_1.IntervalType.VOLUME;
        case DeviceTelemetryType_1.DeviceTelemetryType.BUNDLED_APPLET:
            return telemetryIntervals_1.IntervalType.BUNDLED_APPLET;
        case DeviceTelemetryType_1.DeviceTelemetryType.PROXY:
            return telemetryIntervals_1.IntervalType.PROXY;
        case DeviceTelemetryType_1.DeviceTelemetryType.WIFI_STRENGTH:
            return telemetryIntervals_1.IntervalType.WIFI_STRENGTH;
        case DeviceTelemetryType_1.DeviceTelemetryType.AUTO_RECOVERY:
            return telemetryIntervals_1.IntervalType.AUTO_RECOVERY;
        case DeviceTelemetryType_1.DeviceTelemetryType.PEER_RECOVERY:
            return telemetryIntervals_1.IntervalType.PEER_RECOVERY;
        case DeviceTelemetryType_1.DeviceTelemetryType.MANAGEMENT_CAPABILITIES:
            return telemetryIntervals_1.IntervalType.MANAGEMENT_CAPABILITIES;
        case DeviceTelemetryType_1.DeviceTelemetryType.NETWORK_INTERFACES:
            return telemetryIntervals_1.IntervalType.NETWORK_INTERFACES;
        case DeviceTelemetryType_1.DeviceTelemetryType.DISPLAY_POWER_ON:
            return telemetryIntervals_1.IntervalType.DISPLAY_POWER_ON;
        case DeviceTelemetryType_1.DeviceTelemetryType.APP_MODULES:
            return telemetryIntervals_1.IntervalType.APP_MODULES;
        case DeviceTelemetryType_1.DeviceTelemetryType.FEATURE_FLAGS:
            return telemetryIntervals_1.IntervalType.FEATURE_FLAGS;
        case DeviceTelemetryType_1.DeviceTelemetryType.CRYPTOGRAPHIC_KEY:
            return telemetryIntervals_1.IntervalType.CRYPTOGRAPHIC_KEY;
        case DeviceTelemetryType_1.DeviceTelemetryType.EXTENDED_MANAGEMENT:
            return telemetryIntervals_1.IntervalType.EXTENDED_MANAGEMENT_URL;
        default:
            return telemetryIntervals_1.IntervalType.DEFAULT;
    }
}
function convertTypeToAction(type) {
    switch (type) {
        case DeviceTelemetryType_1.DeviceTelemetryType.BRIGHTNESS:
            return deviceBrightnessActions_1.SetDeviceBrightnessSucceeded;
        case DeviceTelemetryType_1.DeviceTelemetryType.DATETIME:
            return deviceDateTimeActions_1.UpdateDeviceTimeSettingsSucceed;
        case DeviceTelemetryType_1.DeviceTelemetryType.DEBUG:
            return deviceDebugActions_1.SetDeviceDebugSettingsSucceeded;
        case DeviceTelemetryType_1.DeviceTelemetryType.ORIENTATION:
            return deviceResolutionActions_1.DeviceResizeSucceeded;
        case DeviceTelemetryType_1.DeviceTelemetryType.POWER_ACTIONS_SCHEDULE:
            return devicePowerActions_1.SchedulePowerActionSucceed;
        case DeviceTelemetryType_1.DeviceTelemetryType.PROPRIETARY_TIMERS:
            return deviceTimerActions_1.SetDeviceTimerSettingsSucceeded;
        case DeviceTelemetryType_1.DeviceTelemetryType.REMOTE_CONTROL:
            return deviceRemoteControlActions_1.SetDeviceRemoteControlSettingsSucceeded;
        case DeviceTelemetryType_1.DeviceTelemetryType.RESOLUTION:
            return deviceResolutionActions_1.DeviceResizeSucceeded;
        case DeviceTelemetryType_1.DeviceTelemetryType.TIMERS:
            return deviceTimerActions_1.SetDeviceTimerSettingsSucceeded;
        case DeviceTelemetryType_1.DeviceTelemetryType.VOLUME:
            return deviceAudioActions_1.SetDeviceVolumeSucceeded;
        case DeviceTelemetryType_1.DeviceTelemetryType.AUTO_RECOVERY:
            return deviceAutoRecoveryActions_1.SetDeviceAutoRecoverySucceeded;
        case DeviceTelemetryType_1.DeviceTelemetryType.PEER_RECOVERY:
            return devicePeerRecoveryActions_1.SetDevicePeerRecoverySucceeded;
        case DeviceTelemetryType_1.DeviceTelemetryType.EXTENDED_MANAGEMENT:
            return deviceExtendedManagementActions_1.SetExtendedManagementUrlSucceeded;
        case DeviceTelemetryType_1.DeviceTelemetryType.NETWORK_INTERFACES:
            return networkActions_1.NetworkStatusChanged;
        case DeviceTelemetryType_1.DeviceTelemetryType.DISPLAY_POWER_ON:
            return devicePowerActions_1.PerformPowerActionSucceed;
        case DeviceTelemetryType_1.DeviceTelemetryType.CRYPTOGRAPHIC_KEY:
            return deviceCryptographicSaga_1.CryptographicKeyChanged;
        default:
            return;
    }
}
//# sourceMappingURL=deviceTelemetrySagas.js.map