import { MonitoringLogData } from '@signageos/common-types/dist/Device/MonitoringLog/MonitoringLogData';
import { DeviceSettingsType } from '@signageos/common-types/dist/Device/Settings/DeviceSettingsType';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import { IResponsibilities } from '../../../Feature/Responsibilities';
import Responsibility from '../../../Feature/Responsibility';
import IManagementDriver from '../../../NativeDevice/Management/IManagementDriver';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import { PowerActionRules } from '../../../NativeDevice/Power/IPowerActionTimer';
import Property from '../../../Property/Property';
import { IPropertyStorage } from '../../../Property/propertyStorage';
import { IProprietaryTimerStorage } from '../../../Timer/ITimerStorage';
import IGetTelemetryProperties from './IGetTelemetryProperties';
type IGetSettings<T extends DeviceTelemetryType> = (properties: IGetTelemetryProperties) => Promise<MonitoringLogData[T]> | Iterator<unknown>;
export declare const createDeviceTelemetrySaga: <T extends DeviceTelemetryType>(type: T, responsibility: Responsibility, requiredCapabilities: ManagementCapability[], getSettings: IGetSettings<T>) => import("redux-saga").Saga<[responsibilities: IResponsibilities, getManagementDriver: () => IManagementDriver, propertyStorage: IPropertyStorage, timerStorage: IProprietaryTimerStorage, powerActionRules: () => Promise<PowerActionRules>, applicationVersion: string]>;
export declare function getPropertyName(type: DeviceSettingsType, prefix: string): Property;
export declare function getTelemetryPropertyName(type: DeviceTelemetryType, prefix: string): Property;
export {};
