"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceStorageSaga = void 0;
const effects_1 = require("redux-saga/effects");
const channels_1 = require("../../../ReduxSaga/channels");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const storageActions_1 = require("@signageos/actions/dist/Device/Storage/storageActions");
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const dependencyInjection_1 = require("../../../DI/dependencyInjection");
const IConfig_1 = require("../../../Display/IConfig");
const responsible_1 = require("../../../Feature/responsible");
const capable_1 = require("../../../Feature/capable");
const deviceTelemetryHelper_1 = require("../Telemetry/deviceTelemetryHelper");
const createDeviceStorageSaga = () => (0, responsible_1.whenResponsible)(Responsibility_1.default.STORAGE, (0, capable_1.whenCapable)(ManagementCapability_1.default.STORAGE_UNITS, (0, dependencyInjection_1.withDependencies)(['managementDriver', 'subscriptionType', 'telemetryIntervals'], function* ({ managementDriver, subscriptionType, telemetryIntervals }) {
    var _a;
    const periodMs = (_a = telemetryIntervals === null || telemetryIntervals === void 0 ? void 0 : telemetryIntervals.storage) !== null && _a !== void 0 ? _a : 0;
    yield (0, deviceTelemetryHelper_1.registerTelemetry)('STORAGE', periodMs, function* () {
        try {
            yield updateStorageStatus(managementDriver);
        }
        catch (error) {
            console.error('deviceStorageSaga', error);
        }
    });
    const storageChangesChannel = (0, channels_1.createChannel)((putHere) => managementDriver.fileSystem.onStorageUnitsChanged(() => putHere(undefined)));
    yield (0, channels_1.takeEvery)(storageChangesChannel, function* () {
        try {
            if (subscriptionType === IConfig_1.SubscriptionType.platform) {
                yield updateStorageStatus(managementDriver);
            }
        }
        catch (error) {
            console.error('deviceStorageSaga', error);
        }
    });
})));
exports.createDeviceStorageSaga = createDeviceStorageSaga;
function* updateStorageStatus(nativeDriver) {
    const storageUnits = yield nativeDriver.fileSystem.listStorageUnits();
    yield (0, effects_1.put)({
        type: storageActions_1.NotifyStorageStatus,
        storageStatus: {
            storageUnits,
        },
    });
}
//# sourceMappingURL=deviceStorageSaga.js.map