"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getData = exports.telemetryCryptographicSaga = void 0;
const deviceTelemetrySagas_1 = require("../Telemetry/deviceTelemetrySagas");
const DeviceTelemetryType_1 = require("@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType");
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
exports.telemetryCryptographicSaga = (0, deviceTelemetrySagas_1.createDeviceTelemetrySaga)(DeviceTelemetryType_1.DeviceTelemetryType.CRYPTOGRAPHIC_KEY, Responsibility_1.default.SECRET_MANAGEMENT, [ManagementCapability_1.default.SECRETS], getData);
function getData({ managementDriver }) {
    return __awaiter(this, void 0, void 0, function* () {
        const keyData = yield managementDriver.secretManager.getPublicKey();
        return Object.assign(Object.assign(Object.assign({}, algorithmToTelemetry(keyData.algorithm)), keyValidityToTelemetry(keyData.keyValidity)), { publicKey: {
                spki: keyData.publicKeySpki,
            } });
    });
}
exports.getData = getData;
// https://developer.mozilla.org/en-US/docs/Web/API/SubtleCrypto/generateKey#parameters
const algorithmToTelemetry = (algorithm) => {
    if (!algorithm) {
        return {};
    }
    const encryptionPaddings = [];
    switch (algorithm.name) {
        case 'RSA-OAEP':
            encryptionPaddings.push('OAEP');
            break;
        default:
            throw new Error(`Unsupported algorithm: ${algorithm.name}`);
    }
    return {
        algorithm: 'RSA',
        keySize: algorithm.modulusLength,
        digests: [algorithm.hash.name],
        encryptionPaddings,
    };
};
const keyValidityToTelemetry = (keyValidity) => {
    if ((keyValidity === null || keyValidity === void 0 ? void 0 : keyValidity.start) || (keyValidity === null || keyValidity === void 0 ? void 0 : keyValidity.end)) {
        return {
            keyValidity: {
                start: keyValidity === null || keyValidity === void 0 ? void 0 : keyValidity.start,
                forOriginationEnd: keyValidity === null || keyValidity === void 0 ? void 0 : keyValidity.end,
                forConsumptionEnd: keyValidity === null || keyValidity === void 0 ? void 0 : keyValidity.end,
            },
        };
    }
    else {
        return {};
    }
};
//# sourceMappingURL=deviceCryphotraphicTelemetrySaga.js.map