"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.syncRemoteControlSettingsSaga = exports.setDeviceRemoteControlSettingsCallback = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const deviceRemoteControlActions_1 = require("@signageos/actions/dist/Device/RemoteControl/deviceRemoteControlActions");
const deviceRemoteControlActions_2 = require("../../../Device/RemoteControl/deviceRemoteControlActions");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const processCallback_1 = __importDefault(require("../../../Util/processCallback"));
function* setDeviceRemoteControlSettingsCallback(getNativeDriver, action) {
    const nativeDriver = getNativeDriver();
    try {
        const finalizeCallback = yield (0, effects_1.apply)(nativeDriver, nativeDriver.remoteControlSetEnabled, [action.enabled]);
        yield (0, effects_1.put)({
            type: deviceRemoteControlActions_1.SetDeviceRemoteControlSettingsSucceeded,
            uid: action.uid,
        });
        yield (0, effects_1.put)({
            type: deviceRemoteControlActions_2.DeviceRemoteControlSet,
            enabled: action.enabled,
        });
        yield (0, effects_1.call)(processCallback_1.default, finalizeCallback);
    }
    catch (error) {
        yield (0, effects_1.put)({
            type: deviceRemoteControlActions_1.SetDeviceRemoteControlSettingsFailed,
            uid: action.uid,
        });
    }
}
exports.setDeviceRemoteControlSettingsCallback = setDeviceRemoteControlSettingsCallback;
function* syncRemoteControlSettingsSaga(getNativeDriver, responsibilities) {
    if (!responsibilities.has(Responsibility_1.default.KIOSK)) {
        return;
    }
    yield (0, socketActionCreator_1.bindWhenPlatform)(deviceRemoteControlActions_1.SetDeviceRemoteControlSettings);
    const supportsRCEnabled = yield getNativeDriver().managementSupports(ManagementCapability_1.default.SET_REMOTE_CONTROL_ENABLED);
    if (supportsRCEnabled) {
        yield (0, effects_1.takeEvery)(deviceRemoteControlActions_1.SetDeviceRemoteControlSettings, setDeviceRemoteControlSettingsCallback, getNativeDriver);
    }
}
exports.syncRemoteControlSettingsSaga = syncRemoteControlSettingsSaga;
//# sourceMappingURL=deviceRemoteControlSagas.js.map